/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.HasPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.AbstractNativeServerSCMHeadEvent;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerPushWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerAPIClient;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerCommit;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerChange;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.google.common.base.Ascii;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.apache.commons.lang3.Strings;

final class ServerPushEvent
extends AbstractNativeServerSCMHeadEvent<Collection<NativeServerChange>>
implements HasPullRequests {
    private static final Logger LOGGER = Logger.getLogger(ServerPushWebhookProcessor.class.getName());
    private final BitbucketServerRepository repository;
    private final BitbucketServerCommit refCommit;
    private final Map<CacheKey, Map<String, BitbucketServerPullRequest>> cachedPullRequests = new HashMap<CacheKey, Map<String, BitbucketServerPullRequest>>();
    private final String mirrorId;

    ServerPushEvent(String serverURL, SCMEvent.Type type, Collection<NativeServerChange> payload, String origin, BitbucketServerRepository repository, @CheckForNull BitbucketServerCommit headCommit, String mirrorId) {
        super(serverURL, type, payload, origin);
        this.repository = repository;
        this.mirrorId = mirrorId;
        this.refCommit = headCommit;
    }

    @Override
    protected BitbucketServerRepository getRepository() {
        return this.repository;
    }

    @Override
    protected Map<SCMHead, SCMRevision> heads(BitbucketSCMSource source) {
        HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>();
        if (!this.eventMatchesRepo(source)) {
            return result;
        }
        this.addBranchesAndTags(source, result);
        this.addPullRequests(source, result);
        return result;
    }

    private void addBranchesAndTags(BitbucketSCMSource src, Map<SCMHead, SCMRevision> result) {
        for (NativeServerChange change : (Collection)this.getPayload()) {
            String refType = change.getRef().getType();
            if ("BRANCH".equals(refType)) {
                BranchSCMHead head = new BranchSCMHead(change.getRef().getDisplayId());
                AbstractGitSCMSource.SCMRevisionImpl revision = this.getType() == SCMEvent.Type.REMOVED ? null : new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, change.getToHash());
                result.put(head, (SCMRevision)revision);
                continue;
            }
            if ("TAG".equals(refType)) {
                String tagName = change.getRef().getDisplayId();
                long tagTimestamp = 0L;
                try (BitbucketApi client = this.getClient(src);){
                    String tagHash = switch (change.getType()) {
                        case "ADD" -> change.getToHash();
                        case "DELETE" -> change.getFromHash();
                        default -> throw new UnsupportedOperationException("Tag event of type " + change.getType() + " is not supported.\nPlease fill an issue at https://issues.jenkins.io to the bitbucket-branch-source-plugin component.");
                    };
                    if (this.refCommit != null) {
                        tagTimestamp = Optional.ofNullable(this.refCommit.getCommitterDate()).map(Date::getTime).orElse(0L);
                    } else {
                        BitbucketCommit tag = client.resolveCommit(tagHash);
                        if (tag != null) {
                            tagTimestamp = Optional.ofNullable(tag.getCommitterDate()).map(Date::getTime).orElse(0L);
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Fail to retrive the timestamp for tag event {0}", tagName);
                }
                BitbucketTagSCMHead head = new BitbucketTagSCMHead(tagName, tagTimestamp);
                AbstractGitSCMSource.SCMRevisionImpl revision = this.getType() == SCMEvent.Type.REMOVED ? null : new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, change.getToHash());
                result.put((SCMHead)head, (SCMRevision)revision);
                continue;
            }
            LOGGER.log(Level.INFO, "Received event for unknown ref type {0} of ref {1}", new Object[]{change.getRef().getType(), change.getRef().getDisplayId()});
        }
    }

    protected BitbucketApi getClient(BitbucketSCMSource src) {
        String serverURL = src.getServerUrl();
        StandardCredentials credentials = BitbucketCredentialsUtils.lookupCredentials((Item)src.getOwner(), serverURL, src.getCredentialsId(), StandardCredentials.class);
        BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(serverURL), (Credentials)credentials);
        return BitbucketApiFactory.newInstance(serverURL, authenticator, src.getRepoOwner(), null, src.getRepository());
    }

    private void addPullRequests(BitbucketSCMSource src, Map<SCMHead, SCMRevision> result) {
        if (this.getType() != SCMEvent.Type.UPDATED) {
            return;
        }
        BitbucketSCMSourceContext ctx = this.contextOf(src);
        if (!ctx.wantPRs()) {
            return;
        }
        String sourceOwnerName = src.getRepoOwner();
        String sourceRepoName = src.getRepository();
        BitbucketServerRepository eventRepo = this.repository;
        SCMHeadOrigin headOrigin = src.originOf(eventRepo.getOwnerName(), eventRepo.getRepositoryName());
        Set<ChangeRequestCheckoutStrategy> strategies = headOrigin == SCMHeadOrigin.DEFAULT ? ctx.originPRStrategies() : ctx.forkPRStrategies();
        for (NativeServerChange change : (Collection)this.getPayload()) {
            if (!"BRANCH".equals(change.getRef().getType())) {
                LOGGER.log(Level.INFO, "Received event for unknown ref type {0} of ref {1}", new Object[]{change.getRef().getType(), change.getRef().getDisplayId()});
                continue;
            }
            for (BitbucketServerPullRequest pullRequest : this.getPullRequests(src, change).values()) {
                BitbucketServerRepository targetRepo = pullRequest.getDestination().getRepository();
                if (!Strings.CI.equals(sourceOwnerName, targetRepo.getOwnerName()) || !sourceRepoName.equalsIgnoreCase(targetRepo.getRepositoryName())) continue;
                for (ChangeRequestCheckoutStrategy strategy : strategies) {
                    if (strategy != ChangeRequestCheckoutStrategy.MERGE && !change.getRefId().equals(pullRequest.getSource().getRefId())) continue;
                    String originalBranchName = pullRequest.getSource().getBranch().getName();
                    String branchName = String.format("PR-%s%s", pullRequest.getId(), strategies.size() > 1 ? "-" + Ascii.toLowerCase((String)strategy.name()) : "");
                    BitbucketServerRepository pullRequestRepository = pullRequest.getSource().getRepository();
                    PullRequestSCMHead head = new PullRequestSCMHead(branchName, pullRequestRepository.getOwnerName(), pullRequestRepository.getRepositoryName(), originalBranchName, pullRequest, headOrigin, strategy);
                    String targetHash = pullRequest.getDestination().getCommit().getHash();
                    String pullHash = pullRequest.getSource().getCommit().getHash();
                    result.put(head, (SCMRevision)new PullRequestSCMRevision(head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), targetHash), (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, pullHash)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BitbucketServerPullRequest> getPullRequests(BitbucketSCMSource src, NativeServerChange change) {
        Map<String, BitbucketServerPullRequest> pullRequests;
        CacheKey cacheKey = new CacheKey(src, change);
        Map<CacheKey, Map<String, BitbucketServerPullRequest>> map = this.cachedPullRequests;
        synchronized (map) {
            pullRequests = this.cachedPullRequests.get(cacheKey);
            if (pullRequests == null) {
                pullRequests = this.loadPullRequests(src, change);
                this.cachedPullRequests.put(cacheKey, pullRequests);
            }
        }
        return pullRequests;
    }

    private Map<String, BitbucketServerPullRequest> loadPullRequests(BitbucketSCMSource src, NativeServerChange change) {
        BitbucketServerRepository eventRepo = this.repository;
        HashMap<String, BitbucketServerPullRequest> pullRequests = new HashMap<String, BitbucketServerPullRequest>();
        try (BitbucketServerAPIClient api = (BitbucketServerAPIClient)src.buildBitbucketClient(eventRepo.getOwnerName(), eventRepo.getRepositoryName());){
            try {
                for (BitbucketServerPullRequest pullRequest : api.getOutgoingOpenPullRequests(change.getRefId())) {
                    pullRequests.put(pullRequest.getId(), pullRequest);
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException | RuntimeException e) {
                LOGGER.log(Level.WARNING, "Failed to retrieve outgoing Pull Requests from Bitbucket", e);
            }
            try {
                for (BitbucketServerPullRequest pullRequest : api.getIncomingOpenPullRequests(change.getRefId())) {
                    pullRequests.put(pullRequest.getId(), pullRequest);
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException | RuntimeException e) {
                LOGGER.log(Level.WARNING, "Failed to retrieve incoming Pull Requests from Bitbucket", e);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "No such Repository on Bitbucket: {0}", e.getMessage());
        }
        catch (IOException e1) {
            LOGGER.log(Level.INFO, "Comunication fail with server", e1);
        }
        return pullRequests;
    }

    public Collection<BitbucketPullRequest> getPullRequests(BitbucketSCMSource src) throws InterruptedException {
        ArrayList<BitbucketPullRequest> prs = new ArrayList<BitbucketPullRequest>();
        for (NativeServerChange change : (Collection)this.getPayload()) {
            Map<String, BitbucketServerPullRequest> prsForChange = this.getPullRequests(src, change);
            prs.addAll(prsForChange.values());
        }
        return prs;
    }

    @Override
    protected boolean eventMatchesRepo(BitbucketSCMSource source) {
        return Strings.CI.equals(source.getMirrorId(), this.mirrorId) && super.eventMatchesRepo(source);
    }

    private static final class CacheKey {
        @NonNull
        private final String refId;
        @CheckForNull
        private final String credentialsId;

        CacheKey(BitbucketSCMSource src, NativeServerChange change) {
            this.refId = Objects.requireNonNull(change.getRefId());
            this.credentialsId = src.getCredentialsId();
        }

        public int hashCode() {
            return Objects.hash(this.credentialsId, this.refId);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)obj;
                return Objects.equals(this.credentialsId, cacheKey.credentialsId) && Objects.equals(this.refId, cacheKey.refId);
            }
            return false;
        }
    }
}

