/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.relocate;

import com.cloudbees.hudson.plugins.folder.relocate.RelocationHandler;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.security.AccessControlled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(ordinal=-1000.0)
@Restricted(value={NoExternalUse.class})
public final class StandardHandler
extends RelocationHandler {
    @Override
    public RelocationHandler.HandlingMode applicability(Item item) {
        if (item instanceof TopLevelItem && item instanceof AbstractItem && item.getParent() instanceof DirectlyModifiableTopLevelItemGroup) {
            return RelocationHandler.HandlingMode.HANDLE;
        }
        return RelocationHandler.HandlingMode.SKIP;
    }

    @Override
    public HttpResponse handle(Item item, ItemGroup<?> destination, AtomicReference<Item> newItem, List<? extends RelocationHandler> chain) throws IOException, InterruptedException {
        if (!(destination instanceof DirectlyModifiableTopLevelItemGroup)) {
            return chain.isEmpty() ? null : chain.get(0).handle(item, destination, newItem, chain.subList(1, chain.size()));
        }
        Object result = StandardHandler.doMove(item, (DirectlyModifiableTopLevelItemGroup)destination);
        newItem.set((Item)result);
        return HttpResponses.redirectViaContextPath((String)(result.getParent().getUrl() + result.getShortUrl()));
    }

    private static <I extends AbstractItem> I doMove(Item item, DirectlyModifiableTopLevelItemGroup destination) throws IOException {
        return (I)Items.move((AbstractItem)((AbstractItem)item), (DirectlyModifiableTopLevelItemGroup)destination);
    }

    @Override
    public List<? extends ItemGroup<?>> validDestinations(Item item) {
        ArrayList<Object> result = new ArrayList<Object>();
        Jenkins instance = Jenkins.getInstance();
        if (this.permitted(item, (DirectlyModifiableTopLevelItemGroup)instance)) {
            result.add(instance);
        }
        block0: for (Item g : instance.getAllItems()) {
            DirectlyModifiableTopLevelItemGroup itemGroup;
            if (!(g instanceof DirectlyModifiableTopLevelItemGroup) || !this.permitted(item, itemGroup = (DirectlyModifiableTopLevelItemGroup)g)) continue;
            DirectlyModifiableTopLevelItemGroup p = itemGroup;
            while (p instanceof Item) {
                Item i = (Item)p;
                if (i == item) continue block0;
                p = i.getParent();
            }
            result.add(itemGroup);
        }
        return result;
    }

    private boolean permitted(Item item, DirectlyModifiableTopLevelItemGroup itemGroup) {
        return itemGroup == item.getParent() || itemGroup.canAdd((TopLevelItem)item) && ((AccessControlled)itemGroup).hasPermission(Job.CREATE);
    }
}

