/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.model.TopLevelItem;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class ChildNameGenerator<P extends AbstractFolder<I>, I extends TopLevelItem> {
    public static final String CHILD_NAME_FILE = "name-utf8.txt";
    private static final Map<Trace, String> idealNames = new WeakHashMap<Trace, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final Trace beforeCreateItem(@Nonnull AbstractFolder<?> project, @Nonnull String itemName, @Nonnull String idealName) {
        Trace trace = new Trace(project, itemName);
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            idealNames.put(trace, idealName);
        }
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void afterItemCreated(@Nonnull Trace trace) {
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            idealNames.remove(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    protected final String idealNameFromItem(@Nonnull P parent, @Nonnull I item) {
        String itemName = item.getName();
        if (itemName == null) {
            return null;
        }
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            return idealNames.get(new Trace((AbstractFolder)((Object)parent), itemName));
        }
    }

    @CheckForNull
    public abstract String itemNameFromItem(@Nonnull P var1, @Nonnull I var2);

    @CheckForNull
    public abstract String dirNameFromItem(@Nonnull P var1, @Nonnull I var2);

    @Nonnull
    public abstract String itemNameFromLegacy(@Nonnull P var1, @Nonnull String var2);

    @Nonnull
    public abstract String dirNameFromLegacy(@Nonnull P var1, @Nonnull String var2);

    public abstract void recordLegacyName(P var1, I var2, String var3) throws IOException;

    public static final class Trace
    implements Closeable {
        @Nonnull
        private final AbstractFolder<?> folder;
        @Nonnull
        private final String itemName;

        private Trace(@Nonnull AbstractFolder<?> folder, @Nonnull String itemName) {
            this.folder = folder;
            this.itemName = itemName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trace that = (Trace)o;
            return this.folder == that.folder && this.itemName.equals(that.itemName);
        }

        public int hashCode() {
            int result = ((Object)this.folder).hashCode();
            result = 31 * result + this.itemName.hashCode();
            return result;
        }

        @Override
        public void close() {
            ChildNameGenerator.afterItemCreated(this);
        }
    }
}

