/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.properties;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.properties.AbstractPropertiesProvider;
import org.jenkinsci.plugins.configfiles.properties.security.HasPropertyCredentialMappings;
import org.jenkinsci.plugins.configfiles.properties.security.PropertiesCredentialMapping;
import org.kohsuke.stapler.DataBoundConstructor;

public class PropertiesConfig
extends Config
implements HasPropertyCredentialMappings {
    private static final long serialVersionUID = 1L;
    private List<PropertiesCredentialMapping> propertiesCredentialMappings;
    public Boolean isReplaceAll = isReplaceAllDefault;
    public static final Boolean isReplaceAllDefault = Boolean.TRUE;

    @DataBoundConstructor
    public PropertiesConfig(String id, String name, String comment, String content, Boolean isReplaceAll, List<PropertiesCredentialMapping> propertiesCredentialMappings) {
        super(id, name, comment, content, PropertiesConfigProvider.class.getName());
        this.propertiesCredentialMappings = propertiesCredentialMappings == null ? new ArrayList() : propertiesCredentialMappings;
        this.isReplaceAll = null == isReplaceAll ? isReplaceAllDefault : isReplaceAll;
    }

    @Override
    public List<PropertiesCredentialMapping> getPropertiesCredentialMappings() {
        return this.propertiesCredentialMappings == null ? new ArrayList() : this.propertiesCredentialMappings;
    }

    @Override
    public Boolean getIsReplaceAll() {
        return this.isReplaceAll;
    }

    @Extension(ordinal=190.0)
    public static class PropertiesConfigProvider
    extends AbstractPropertiesProvider {
        public PropertiesConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return ContentType.DefinedType.PROPERTIES;
        }

        public String getDisplayName() {
            return Messages.properties_provider_description();
        }

        @Override
        @NonNull
        public Config newConfig(@NonNull String id) {
            return new PropertiesConfig(id, Messages.PropertiesConfig_SettingsName(), Messages.PropertiesConfig_SettingsComment(), "", isReplaceAllDefault, Collections.emptyList());
        }
    }
}

