/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.configprovider.model;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ConfigFile;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.buildwrapper.Messages;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class ConfigFileManager {
    private static final Logger LOGGER = Logger.getLogger(ConfigFileManager.class.getName());

    public static FilePath tempDir(FilePath ws) {
        return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
    }

    public static FilePath provisionConfigFile(ConfigFile configFile, @Nullable EnvVars env, Run<?, ?> build, FilePath workspace, TaskListener listener, List<String> tempFiles) throws IOException, InterruptedException {
        FilePath target;
        Object config = ConfigFiles.getByIdOrNull(build, configFile.getFileId());
        if (config == null) {
            String message = "not able to provide the file " + configFile + ", can't be resolved by any provider - maybe it got deleted by an administrator?";
            listener.getLogger().println(message);
            throw new AbortException(message);
        }
        FilePath workDir = ConfigFileManager.tempDir(workspace);
        workDir.mkdirs();
        boolean createTempFile = StringUtils.isBlank((String)configFile.getTargetLocation());
        if (createTempFile) {
            target = workDir.createTempFile("config", "tmp");
        } else {
            String expandedTargetLocation = configFile.getTargetLocation();
            try {
                expandedTargetLocation = TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)configFile.getTargetLocation());
            }
            catch (MacroEvaluationException e) {
                listener.getLogger().println("[ERROR] failed to expand variables in target location '" + configFile.getTargetLocation() + "' : " + e.getMessage());
                expandedTargetLocation = configFile.getTargetLocation();
            }
            target = new FilePath(workspace, expandedTargetLocation);
            String immediateFileName = expandedTargetLocation.substring(expandedTargetLocation.lastIndexOf("/") + 1);
            if (immediateFileName.length() == 0 || target.exists() && target.isDirectory()) {
                target = new FilePath(target, ((Config)config).name.replace(" ", "_"));
            }
        }
        ConfigProvider provider = ((Config)config).getDescriptor();
        String fileContent = provider.supplyContent((Config)config, build, workDir, listener, tempFiles);
        if (configFile.isReplaceTokens()) {
            try {
                fileContent = TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)fileContent);
                if (env != null) {
                    fileContent = Util.replaceMacro((String)fileContent, (Map)env);
                }
            }
            catch (MacroEvaluationException e) {
                listener.getLogger().println("[ERROR] failed to expand variables in content of " + ((Config)config).name + " - " + e.getMessage());
            }
        }
        LOGGER.log(Level.FINE, "Create file {0} for configuration {1} mapped as {2}", new Object[]{target.getRemote(), config, configFile});
        listener.getLogger().println(Messages.console_output(((Config)config).name, target.toURI()));
        if (fileContent != null) {
            ByteArrayInputStream bs = new ByteArrayInputStream(fileContent.getBytes("UTF-8"));
            target.copyFrom((InputStream)bs);
        }
        target.chmod(416);
        return target;
    }
}

