/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Plugin;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigByNameComparator;
import org.jenkinsci.plugins.configfiles.ConfigContextResolver;
import org.jenkinsci.plugins.configfiles.ConfigFileStore;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.jenkinsci.plugins.configfiles.folder.FolderConfigFileProperty;

public class ConfigFiles {
    private static final Logger LOGGER = Logger.getLogger(ConfigFiles.class.getName());

    private ConfigFiles() {
    }

    private static final boolean folderPluginInstalled() {
        Plugin folderPlugin = Jenkins.getActiveInstance().getPlugin("cloudbees-folder");
        return folderPlugin != null;
    }

    @NonNull
    public static List<Config> getConfigsInContext(@Nullable ItemGroup itemGroup, Class<? extends Descriptor> descriptor) {
        ArrayList<Config> configs = new ArrayList<Config>();
        while (itemGroup != null) {
            AbstractFolder folder;
            ConfigFileStore store;
            itemGroup = ConfigFiles.resolveItemGroup(itemGroup);
            if (ConfigFiles.folderPluginInstalled() && itemGroup instanceof AbstractFolder && (store = (ConfigFileStore)(folder = (AbstractFolder)AbstractFolder.class.cast(itemGroup)).getProperties().get(FolderConfigFileProperty.class)) != null) {
                if (descriptor == null) {
                    configs.addAll(store.getConfigs());
                } else {
                    configs.addAll(store.getConfigs(descriptor));
                }
            }
            if (itemGroup instanceof Item) {
                itemGroup = ((Item)Item.class.cast(itemGroup)).getParent();
            }
            if (!(itemGroup instanceof Jenkins)) continue;
            if (descriptor == null) {
                configs.addAll(GlobalConfigFiles.get().getConfigs());
            } else {
                configs.addAll(GlobalConfigFiles.get().getConfigs(descriptor));
            }
            itemGroup = null;
        }
        Collections.sort(configs, ConfigByNameComparator.INSTANCE);
        return configs;
    }

    public static <T extends Config> T getByIdOrNull(@Nullable ItemGroup itemGroup, @NonNull String configId) {
        while (itemGroup != null) {
            Config config;
            AbstractFolder folder;
            ConfigFileStore store;
            itemGroup = ConfigFiles.resolveItemGroup(itemGroup);
            if (ConfigFiles.folderPluginInstalled() && itemGroup instanceof AbstractFolder && (store = (ConfigFileStore)(folder = (AbstractFolder)AbstractFolder.class.cast(itemGroup)).getProperties().get(FolderConfigFileProperty.class)) != null && (config = store.getById(configId)) != null) {
                return (T)config;
            }
            if (itemGroup instanceof Item) {
                itemGroup = ((Item)Item.class.cast(itemGroup)).getParent();
            }
            if (itemGroup instanceof Jenkins) {
                return (T)GlobalConfigFiles.get().getById(configId);
            }
            if (itemGroup instanceof AbstractFolder || itemGroup instanceof Item) continue;
            throw new IllegalArgumentException("can not determine current context/parent for: " + itemGroup.getFullName() + " of type " + itemGroup.getClass());
        }
        return null;
    }

    public static <T extends Config> T getByIdOrNull(@NonNull Item item, @NonNull String configId) {
        if (ConfigFiles.folderPluginInstalled() && item instanceof AbstractFolder) {
            return ConfigFiles.getByIdOrNull((ItemGroup)item, configId);
        }
        if (item != null) {
            LOGGER.log(Level.FINE, "try with: " + item.getParent());
            return ConfigFiles.getByIdOrNull(item.getParent(), configId);
        }
        return null;
    }

    public static <T extends Config> T getByIdOrNull(@NonNull Run<?, ?> build, @NonNull String configId) {
        Job parent = build.getParent();
        T configFile = parent instanceof ItemGroup ? ConfigFiles.getByIdOrNull((ItemGroup)parent, configId) : ConfigFiles.getByIdOrNull((Item)parent, configId);
        return configFile;
    }

    private static ItemGroup resolveItemGroup(ItemGroup itemGroup) {
        for (ConfigContextResolver resolver : ConfigContextResolver.all()) {
            ItemGroup resolvedItemGroup = resolver.getConfigContext(itemGroup);
            if (resolvedItemGroup == null) continue;
            return resolvedItemGroup;
        }
        return itemGroup;
    }
}

