/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles;

import hudson.Extension;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ManagementLink;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.ConfigFileStore;
import org.jenkinsci.plugins.configfiles.ConfigFilesUIContract;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.jenkinsci.plugins.configfiles.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

@Extension
public class ConfigFilesManagement
extends ManagementLink
implements ConfigFilesUIContract,
StaplerProxy {
    public static final String ICON_PATH = "/plugin/config-file-provider/images/cfg_logo.png";
    private ConfigFileStore store = GlobalConfigFiles.get();

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public String getIconFileName() {
        return ICON_PATH;
    }

    @Restricted(value={NoExternalUse.class})
    public String getIconUrl(String rootUrl) {
        if (rootUrl.endsWith("/")) {
            return rootUrl + ICON_PATH.substring(1);
        }
        return rootUrl + ICON_PATH;
    }

    public String getUrlName() {
        return "configfiles";
    }

    @Override
    public ContentType getContentTypeForProvider(String providerId) {
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!provider.getProviderId().equals(providerId)) continue;
            return provider.getContentType();
        }
        return null;
    }

    @Override
    public Map<ConfigProvider, Collection<Config>> getGroupedConfigs() {
        return this.store.getGroupedConfigs();
    }

    @Override
    public List<ConfigProvider> getProviders() {
        return ConfigProvider.all();
    }

    public Collection<Config> getConfigs() {
        return Collections.unmodifiableCollection(this.store.getConfigs());
    }

    @Override
    @POST
    public HttpResponse doSaveConfig(StaplerRequest req) {
        this.checkPermission(Hudson.ADMINISTER);
        try {
            JSONObject json = req.getSubmittedForm().getJSONObject("config");
            Config config = (Config)req.bindJSON(Config.class, json);
            if (!ID_PATTERN.matcher(config.id).matches()) {
                return FormValidation.error((String)Messages.ConfigFilesManagement_configIdContainsInvalidCharacters());
            }
            this.store.save(config);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        return new HttpRedirect("index");
    }

    @Override
    public void doShow(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String confgiId) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        Config config = this.store.getById(confgiId);
        req.setAttribute("contentType", (Object)config.getProvider().getContentType());
        req.setAttribute("config", (Object)config);
        req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/show.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public void doEditConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String confgiId) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        Config config = this.store.getById(confgiId);
        req.setAttribute("contentType", (Object)config.getProvider().getContentType());
        req.setAttribute("config", (Object)config);
        req.setAttribute("provider", (Object)config.getProvider());
        req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    @POST
    public void doAddConfig(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="providerId") String providerId, @QueryParameter(value="configId") String configId) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        FormValidation error = null;
        if (providerId == null || providerId.isEmpty()) {
            error = FormValidation.errorWithMarkup((String)Messages._ConfigFilesManagement_selectTypeOfFileToCreate().toString(req.getLocale()));
        }
        if (configId == null || configId.isEmpty()) {
            error = FormValidation.errorWithMarkup((String)Messages._ConfigFilesManagement_configIdCannotBeEmpty().toString(req.getLocale()));
        }
        if (!ID_PATTERN.matcher(configId).matches()) {
            error = FormValidation.error((String)Messages.ConfigFilesManagement_configIdContainsInvalidCharacters());
        }
        if (error != null) {
            req.setAttribute("error", (Object)error);
            this.checkPermission(Hudson.ADMINISTER);
            req.setAttribute("providers", ConfigProvider.all());
            req.setAttribute("configId", (Object)configId);
            req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/selectprovider.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        ConfigProvider provider = ConfigProvider.getByIdOrNull(providerId);
        if (provider == null) {
            throw new IllegalArgumentException("No provider found for id '" + providerId + "'");
        }
        req.setAttribute("contentType", (Object)provider.getContentType());
        req.setAttribute("provider", (Object)provider);
        Config config = Util.isOverridden(ConfigProvider.class, ((Object)((Object)provider)).getClass(), (String)"newConfig", (Class[])new Class[]{String.class}) ? provider.newConfig(configId) : provider.newConfig();
        config.setProviderId(provider.getProviderId());
        req.setAttribute("config", (Object)config);
        req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public void doSelectProvider(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        req.setAttribute("providers", ConfigProvider.all());
        req.setAttribute("configId", (Object)UUID.randomUUID().toString());
        req.getView((Object)this, "/org/jenkinsci/plugins/configfiles/ConfigFilesUI/selectprovider.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    private void checkPermission(Permission permission) {
        Hudson.getInstance().checkPermission(permission);
    }

    @Override
    public HttpResponse doRemoveConfig(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String configId) throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        this.store.remove(configId);
        return new HttpRedirect("index");
    }

    @Override
    public FormValidation doCheckConfigId(@QueryParameter(value="configId") String configId) {
        if (configId == null || configId.isEmpty()) {
            return FormValidation.warning((String)Messages.ConfigFilesManagement_configIdCannotBeEmpty());
        }
        if (!ID_PATTERN.matcher(configId).matches()) {
            return FormValidation.error((String)Messages.ConfigFilesManagement_configIdContainsInvalidCharacters());
        }
        Config config = this.store.getById(configId);
        if (config == null) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)Messages.ConfigFilesManagement_configIdAlreadyUsed(config.name, config.id));
    }

    public Object getTarget() {
        this.checkPermission(Item.EXTENDED_READ);
        return this;
    }
}

