/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigByNameComparator;
import org.jenkinsci.plugins.configfiles.ConfigFileStore;
import org.jenkinsci.plugins.configfiles.ConfigProviderComparator;
import org.kohsuke.stapler.StaplerRequest;

public class FolderConfigFileProperty
extends AbstractFolderProperty<AbstractFolder<?>>
implements ConfigFileStore {
    private static Comparator<Config> COMPARATOR = new Comparator<Config>(){

        @Override
        public int compare(Config o1, Config o2) {
            return o1.id.compareTo(o2.id);
        }
    };
    private static ConfigProviderComparator CONFIGPROVIDER_COMPARATOR = new ConfigProviderComparator();
    private Collection<Config> configs = new TreeSet<Config>(COMPARATOR);
    private transient AbstractFolder<?> owner;

    FolderConfigFileProperty(AbstractFolder<?> owner) {
        this.setOwner(owner);
    }

    @Override
    public Collection<Config> getConfigs() {
        return this.configs;
    }

    @Override
    public Collection<Config> getConfigs(Class<? extends Descriptor> descriptor) {
        ArrayList<Config> cs = new ArrayList<Config>();
        for (Config c : this.configs) {
            if (!((Object)((Object)c.getDescriptor())).getClass().equals(descriptor)) continue;
            cs.add(c);
        }
        return cs;
    }

    @Override
    public Config getById(String id) {
        if (id != null) {
            for (Config c : this.configs) {
                if (!id.equals(c.id)) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public void save(Config config) {
        this.configs.remove(config);
        this.configs.add(config);
        try {
            this.getOwner().save();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to save config to store", e);
        }
    }

    @Override
    public void remove(String id) {
        Config c = this.getById(id);
        if (c != null) {
            this.configs.remove(c);
            try {
                this.getOwner().save();
            }
            catch (IOException e) {
                throw new RuntimeException("failed to remove config from store", e);
            }
        }
    }

    @Override
    public Map<ConfigProvider, Collection<Config>> getGroupedConfigs() {
        TreeMap<ConfigProvider, Collection<Config>> grouped = new TreeMap<ConfigProvider, Collection<Config>>(CONFIGPROVIDER_COMPARATOR);
        for (Config config : this.configs) {
            ArrayList<Config> configs = (ArrayList<Config>)grouped.get((Object)config.getProvider());
            if (configs == null) {
                configs = new ArrayList<Config>();
                grouped.put(config.getProvider(), configs);
            }
            configs.add(config);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            List value = (List)entry.getValue();
            Collections.sort(value, ConfigByNameComparator.INSTANCE);
        }
        return grouped;
    }

    private Object readResolve() {
        if (!(this.configs instanceof TreeSet)) {
            TreeSet<Config> newConfigs = new TreeSet<Config>(COMPARATOR);
            newConfigs.addAll(this.configs);
            this.configs = newConfigs;
        }
        return this;
    }

    public FolderConfigFileProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return this;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        public String getDisplayName() {
            return "";
        }
    }
}

