/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.maven.AbstractMavenSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.security.HasServerCredentialMappings;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.kohsuke.stapler.DataBoundConstructor;

public class MavenSettingsConfig
extends Config
implements HasServerCredentialMappings {
    private static final long serialVersionUID = 1L;
    private List<ServerCredentialMapping> serverCredentialMappings;
    public Boolean isReplaceAll = isReplaceAllDefault;
    public static final Boolean isReplaceAllDefault = Boolean.TRUE;

    @DataBoundConstructor
    public MavenSettingsConfig(String id, String name, String comment, String content, Boolean isReplaceAll, List<ServerCredentialMapping> serverCredentialMappings) {
        super(id, name, comment, content, MavenSettingsConfigProvider.class.getName());
        this.serverCredentialMappings = serverCredentialMappings == null ? new ArrayList() : serverCredentialMappings;
        this.isReplaceAll = null == isReplaceAll ? isReplaceAllDefault : isReplaceAll;
    }

    @Override
    public List<ServerCredentialMapping> getServerCredentialMappings() {
        return this.serverCredentialMappings == null ? new ArrayList() : this.serverCredentialMappings;
    }

    @Override
    public Boolean getIsReplaceAll() {
        return this.isReplaceAll;
    }

    @Extension(ordinal=190.0)
    public static class MavenSettingsConfigProvider
    extends AbstractMavenSettingsProvider {
        protected transient String ID_PREFIX;

        public MavenSettingsConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.mvn_settings_provider_name();
        }

        @Override
        @NonNull
        public Config newConfig(@NonNull String id) {
            return new MavenSettingsConfig(id, "MySettings", "user settings", this.loadTemplateContent(), isReplaceAllDefault, Collections.emptyList());
        }

        @Override
        protected String getXmlFileName() {
            return "maven-settings-files.xml";
        }

        static {
            Jenkins.XSTREAM.alias("org.jenkinsci.plugins.configfiles.maven.DefaultMavenSettingsProvider", MavenSettingsConfigProvider.class);
        }
    }
}

