/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class MavenToolchainsConfig
extends Config {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public MavenToolchainsConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public MavenToolchainsConfig(String id, String name, String comment, String content, String providerId) {
        super(id, name, comment, content, providerId);
    }

    @Extension(ordinal=180.0)
    public static class MavenToolchainsConfigProvider
    extends AbstractConfigProviderImpl {
        public MavenToolchainsConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.mvn_toolchains_provider_name();
        }

        @Override
        protected String getXmlFileName() {
            return "maven-toolchains-files.xml";
        }

        @Override
        @NonNull
        public Config newConfig(@NonNull String id) {
            return new MavenToolchainsConfig(id, "MyToolchains", "", this.loadTemplateContent(), this.getProviderId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String loadTemplateContent() {
            String string;
            InputStream in = null;
            try {
                in = ((Object)((Object)this)).getClass().getResourceAsStream("toolchains-tpl.xml");
                string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            }
            catch (Exception e) {
                String string2;
                try {
                    string2 = "<toolchains></toolchains>";
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                return string2;
            }
            IOUtils.closeQuietly((InputStream)in);
            return string;
        }
    }
}

