/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.BuildSelectorParameter;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.SimpleBuildSelectorDescriptor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class ParameterizedBuildSelector
extends BuildSelector {
    private String parameterName;
    private static final Logger LOG = Logger.getLogger(ParameterizedBuildSelector.class.getName());
    @Deprecated
    public static Descriptor<BuildSelector> DESCRIPTOR;

    @DataBoundConstructor
    public ParameterizedBuildSelector(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        BuildSelector selector;
        String xml = this.resolveParameter(env);
        if (xml == null) {
            return null;
        }
        try {
            selector = BuildSelectorParameter.getSelectorFromXml(xml);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, String.format("Failed to resolve selector: %s", xml), e);
            return null;
        }
        return selector.getBuild(job, env, filter, parent);
    }

    private String resolveParameter(EnvVars env) {
        if (StringUtils.isBlank((String)this.getParameterName())) {
            LOG.log(Level.WARNING, "Parameter name is not specified");
            return null;
        }
        if (this.getParameterName().contains("<")) {
            LOG.log(Level.FINEST, "{0} is considered a xstream expression", this.getParameterName());
            return this.getParameterName();
        }
        if (this.getParameterName().contains("$")) {
            LOG.log(Level.FINEST, "{0} is considered a variable expression", this.getParameterName());
            return env.expand(this.getParameterName());
        }
        String xml = (String)env.get((Object)this.getParameterName());
        if (xml == null) {
            LOG.log(Level.WARNING, "{0} is not defined", this.getParameterName());
        }
        return xml;
    }

    @Extension(ordinal=-20.0)
    @Symbol(value={"buildParameter"})
    public static final class DescriptorImpl
    extends SimpleBuildSelectorDescriptor {
        public DescriptorImpl() {
            super(ParameterizedBuildSelector.class, Messages._ParameterizedBuildSelector_DisplayName());
            DESCRIPTOR = this;
        }
    }
}

