/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact.monitor;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.AdministrativeMonitor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SaveableListener;
import hudson.plugins.copyartifact.CopyArtifactPermissionProperty;
import hudson.plugins.copyartifact.monitor.LegacyMonitorData;
import hudson.plugins.copyartifact.monitor.Messages;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.lang.Klass;

@Extension
@Symbol(value={"copyArtifactLegacyJobConfigMigration"})
public class LegacyJobConfigMigrationMonitor
extends AdministrativeMonitor
implements Saveable {
    private static final Logger LOGGER = Logger.getLogger(LegacyJobConfigMigrationMonitor.class.getName());
    public static final String ID = "copyArtifactLegacyJobConfigMigration";
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock(true);
    @GuardedBy(value="lock")
    private final LegacyMonitorData data = new LegacyMonitorData();

    public LegacyJobConfigMigrationMonitor() {
        super(ID);
        this.load();
    }

    public String getDisplayName() {
        return Messages.LegacyJobConfigMigrationMonitor_displayName();
    }

    public boolean isActivated() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = !this.data.isEmpty();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    @Restricted(value={NoExternalUse.class})
    LegacyMonitorData getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        XmlFile file = LegacyJobConfigMigrationMonitor.getConfigXml();
        if (!file.exists()) {
            return;
        }
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            file.unmarshal((Object)this);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load " + file, e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        XmlFile config = LegacyJobConfigMigrationMonitor.getConfigXml();
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            config.write((Object)this);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)config);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + config, e);
        }
        finally {
            readLock.unlock();
        }
    }

    @NonNull
    public static XmlFile getConfigXml() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), LegacyJobConfigMigrationMonitor.class.getName() + ".xml"));
    }

    @Restricted(value={DoNotUse.class})
    @NonNull
    public List<LegacyMonitorData.LegacyBuildInfoModel> getAllJobInformation() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<LegacyMonitorData.LegacyBuildInfoModel> list = this.data.buildDataForCurrentUser();
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLegacyJob(@NonNull Job<?, ?> jobTryingToCopy, @NonNull Job<?, ?> jobToBeCopiedFrom, @NonNull Date lastBuildDate, @NonNull String username) {
        LOGGER.log(Level.FINE, "Adding a legacy job to the monitor: from {0} to {1}", new Object[]{jobToBeCopiedFrom.getFullName(), jobTryingToCopy.getFullName()});
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.data.addLegacyJob(jobTryingToCopy, jobToBeCopiedFrom, lastBuildDate, username);
            this.save();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLegacyJob(@NonNull Job<?, ?> jobTryingToCopy, @NonNull Job<?, ?> jobToBeCopiedFrom) {
        String jobToBeCopiedFromName = jobToBeCopiedFrom.getFullName();
        String jobTryingToCopyName = jobTryingToCopy.getFullName();
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            if (this.data.removeLegacyJob(jobToBeCopiedFromName, jobTryingToCopyName)) {
                this.save();
                LOGGER.log(Level.FINE, "Removed a legacy job form the monitor: from {0} to {1}", new Object[]{jobToBeCopiedFromName, jobTryingToCopyName});
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public HttpResponse doIgnoreAllSelected(@JsonBody MigrateAllSelectedModel content) {
        if (content.values == null) {
            return HttpResponses.ok();
        }
        try (BulkChange bc = new BulkChange((Saveable)this);){
            for (MigrateAllSelectedFromAndTo value : content.values) {
                if (value.jobFrom == null || value.jobTo == null) continue;
                this.data.removeLegacyJob(value.jobFrom, value.jobTo);
            }
            bc.commit();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problem during bulk save", e);
        }
        return HttpResponses.ok();
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public HttpResponse doMigrateAllSelected(@JsonBody MigrateAllSelectedModel content) {
        if (content.values == null) {
            return HttpResponses.ok();
        }
        try (ACLContext acl = ACL.as((Authentication)ACL.SYSTEM);){
            try (BulkChange bc = new BulkChange((Saveable)this);){
                for (MigrateAllSelectedFromAndTo value : content.values) {
                    if (value.jobFrom == null || value.jobTo == null || !this.applyAutoMigration(value.jobFrom, value.jobTo)) continue;
                    this.data.removeLegacyJob(value.jobFrom, value.jobTo);
                }
                bc.commit();
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Problem during bulk save", e);
            }
        }
        return HttpResponses.ok();
    }

    private static Job<?, ?> getRootProject(Job<?, ?> job) {
        if (job instanceof AbstractProject) {
            return ((AbstractProject)job).getRootProject();
        }
        return job;
    }

    @Restricted(value={NoExternalUse.class})
    boolean applyAutoMigration(@NonNull String jobFromName, @NonNull String jobToName) throws IOException {
        Jenkins jenkins = Jenkins.get();
        Job<?, ?> jobFrom = LegacyJobConfigMigrationMonitor.getRootProject((Job)jenkins.getItemByFullName(jobFromName, Job.class));
        Job<?, ?> jobTo = LegacyJobConfigMigrationMonitor.getRootProject((Job)jenkins.getItemByFullName(jobToName, Job.class));
        if (jobFrom == null) {
            LOGGER.log(Level.INFO, "Project (from) {0} not found, corresponds with (to) {1}, it was perhaps renamed or removed recently", new Object[]{jobFromName, jobToName});
            return false;
        }
        if (jobTo == null) {
            LOGGER.log(Level.INFO, "Project (to) {0} not found, corresponds with (from) {1}, it was perhaps renamed or removed recently", new Object[]{jobToName, jobFromName});
            return false;
        }
        if (!LegacyJobConfigMigrationMonitor.canMigrate(jobFrom)) {
            LOGGER.log(Level.INFO, "Auto-migration is not applicable to project (from) {0}.", jobFromName);
            return false;
        }
        CopyArtifactPermissionProperty property = (CopyArtifactPermissionProperty)jobFrom.getProperty(CopyArtifactPermissionProperty.class);
        if (property == null) {
            String relativeName = jobTo.getRelativeNameFrom(jobFrom);
            jobFrom.addProperty((JobProperty)new CopyArtifactPermissionProperty(relativeName));
            LOGGER.log(Level.INFO, "Project {0} is now authorized to copy from {1} as {2}", new Object[]{jobFromName, jobToName, relativeName});
        } else if (property.canCopiedBy(jobTo)) {
            LOGGER.log(Level.FINE, "Project {0} was already authorized by {1}", new Object[]{jobToName, jobFromName});
        } else {
            String relativeName = jobTo.getRelativeNameFrom(jobFrom);
            String newProjectNames = property.getProjectNames() + "," + relativeName;
            jobFrom.removeProperty(CopyArtifactPermissionProperty.class);
            jobFrom.addProperty((JobProperty)new CopyArtifactPermissionProperty(newProjectNames));
            LOGGER.log(Level.INFO, "Project {0} is now authorized to copy from {1} as {2}", new Object[]{jobFromName, jobToName, relativeName});
        }
        return true;
    }

    static boolean canMigrate(@CheckForNull Job<?, ?> job) {
        if (job == null) {
            return false;
        }
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return false;
        }
        if (jenkins.getPlugin("cloudbees-folder") == null) {
            return true;
        }
        ItemGroup parent = job.getParent();
        while (parent instanceof Job) {
            parent = ((Job)parent).getParent();
        }
        return !(parent instanceof ComputedFolder);
    }

    @NonNull
    public static LegacyJobConfigMigrationMonitor get() {
        AdministrativeMonitor monitor = Jenkins.get().getAdministrativeMonitor(ID);
        if (monitor instanceof LegacyJobConfigMigrationMonitor) {
            return (LegacyJobConfigMigrationMonitor)monitor;
        }
        throw new AssertionError((Object)("The desired monitor is missing: " + LegacyJobConfigMigrationMonitor.class.getName()));
    }

    @Restricted(value={DoNotUse.class})
    public void doHelpDetailedSteps(StaplerResponse rsp) throws IOException {
        URL url = this.getStaticResourceUrl("help-detailedSteps");
        if (url == null) {
            rsp.sendError(404);
            return;
        }
        rsp.setContentType("text/html; charset=UTF-8");
        IOUtils.copy((InputStream)url.openStream(), (Writer)rsp.getWriter(), (String)"UTF-8");
    }

    private URL getStaticResourceUrl(String base) {
        Locale locale = Stapler.getCurrentRequest().getLocale();
        Klass c = Klass.java(((Object)((Object)this)).getClass());
        URL url = c.getResource(base + '_' + locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant() + ".html");
        if (url != null) {
            return url;
        }
        url = c.getResource(base + '_' + locale.getLanguage() + '_' + locale.getCountry() + ".html");
        if (url != null) {
            return url;
        }
        url = c.getResource(base + '_' + locale.getLanguage() + ".html");
        if (url != null) {
            return url;
        }
        return c.getResource(base + ".html");
    }

    @Extension
    public static final class ListenerImpl
    extends ItemListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRenamed(Item item, String oldName, String newName) {
            String oldFullName = Items.getCanonicalName((ItemGroup)item.getParent(), (String)oldName);
            String newFullName = Items.getCanonicalName((ItemGroup)item.getParent(), (String)newName);
            LegacyJobConfigMigrationMonitor monitor = LegacyJobConfigMigrationMonitor.get();
            Lock writeLock = monitor.lock.writeLock();
            writeLock.lock();
            try {
                monitor.getData().onJobRename(oldFullName, newFullName);
                monitor.save();
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UWF_NULL_FIELD"}, justification="Fields are set from the json in the HTTP request")
    public static final class MigrateAllSelectedFromAndTo {
        public String jobFrom = null;
        public String jobTo = null;
    }

    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UWF_NULL_FIELD"}, justification="Fields are set from the json in the HTTP request")
    public static final class MigrateAllSelectedModel {
        public MigrateAllSelectedFromAndTo[] values = null;
    }
}

