/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact.monitor;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.plugins.copyartifact.monitor.LegacyJobConfigMigrationMonitor;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class LegacyMonitorData {
    private static final Logger LOGGER = Logger.getLogger(LegacyMonitorData.class.getName());
    @NonNull
    private Map<JobKey, LegacyBuildStorage> legacyJobInfos = new HashMap<JobKey, LegacyBuildStorage>();
    @NonNull
    private Map<String, List<JobKey>> fullNameToKey = new HashMap<String, List<JobKey>>();

    public boolean isEmpty() {
        return this.legacyJobInfos.isEmpty();
    }

    public boolean hasJobFullName(@NonNull String jobFullName) {
        return this.fullNameToKey.containsKey(jobFullName);
    }

    public void onJobRename(@NonNull String previousFullName, @NonNull String newFullName) {
        List<JobKey> keys = this.fullNameToKey.get(previousFullName);
        if (keys == null) {
            return;
        }
        ArrayList<JobKey> newKeys = new ArrayList<JobKey>(keys.size());
        for (JobKey key : keys) {
            String otherFullName;
            JobKey newKey;
            if (key.from.equals(previousFullName)) {
                newKey = LegacyMonitorData.buildKey(newFullName, key.to);
                otherFullName = key.to;
            } else {
                newKey = LegacyMonitorData.buildKey(key.from, newFullName);
                otherFullName = key.from;
            }
            newKeys.add(newKey);
            List<JobKey> otherList = this.fullNameToKey.get(otherFullName);
            otherList.remove(key);
            otherList.add(newKey);
            LegacyBuildStorage newBuildInfo = null;
            LegacyBuildStorage buildInfo = this.legacyJobInfos.get(key);
            if (buildInfo != null) {
                if (buildInfo.getJobFullNameFrom().equals(previousFullName)) {
                    LOGGER.log(Level.FINE, "Renaming [from] of {0}, with new name: {1}", new Object[]{buildInfo, newFullName});
                    newBuildInfo = buildInfo.renameJobFrom(newFullName);
                } else if (buildInfo.getJobFullNameTo().equals(previousFullName)) {
                    LOGGER.log(Level.FINE, "Renaming [to] of {0}, with new name: {1}", new Object[]{buildInfo, newFullName});
                    newBuildInfo = buildInfo.renameJobTo(newFullName);
                }
            }
            if (newBuildInfo == null) continue;
            this.legacyJobInfos.remove(key);
            this.legacyJobInfos.put(newKey, newBuildInfo);
        }
        this.fullNameToKey.remove(previousFullName);
        this.fullNameToKey.put(newFullName, newKeys);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    Map<JobKey, LegacyBuildStorage> getLegacyJobInfos() {
        return new HashMap<JobKey, LegacyBuildStorage>(this.legacyJobInfos);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    Map<String, List<JobKey>> getFullNameToKey() {
        HashMap<String, List<JobKey>> result = new HashMap<String, List<JobKey>>();
        this.fullNameToKey.forEach((key, value) -> {
            List cfr_ignored_0 = result.put((String)key, new ArrayList(value));
        });
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    void clear() {
        this.fullNameToKey.clear();
        this.legacyJobInfos.clear();
    }

    @NonNull
    public List<LegacyBuildInfoModel> buildDataForCurrentUser() {
        HashMap jobCache = new HashMap();
        ArrayList<LegacyBuildInfoModel> result = new ArrayList<LegacyBuildInfoModel>();
        this.legacyJobInfos.values().stream().collect(Collectors.groupingBy(LegacyBuildStorage::getJobFullNameFrom)).forEach((jobFullNameFrom, buildInfos) -> {
            JobInfoModel jobFrom = this.retrieveOrBuildJobInfoForCurrentUser(jobCache, (String)jobFullNameFrom);
            LegacyBuildInfoModel model = new LegacyBuildInfoModel(jobFrom);
            buildInfos.forEach(buildInfo -> {
                JobInfoModel jobTo = this.retrieveOrBuildJobInfoForCurrentUser(jobCache, ((LegacyBuildStorage)buildInfo).jobFullNameTo);
                LegacyJobInfoItemModel itemModel = new LegacyJobInfoItemModel(jobTo, ((LegacyBuildStorage)buildInfo).username, ((LegacyBuildStorage)buildInfo).lastBuildDate, ((LegacyBuildStorage)buildInfo).numOfBuild);
                model.addItem(itemModel);
            });
            result.add(model);
        });
        result.sort((a, b) -> ((LegacyBuildInfoModel)a).jobFrom.getJobFullName().compareToIgnoreCase(((LegacyBuildInfoModel)b).jobFrom.getJobFullName()));
        for (LegacyBuildInfoModel jobInfo : result) {
            jobInfo.jobToList.sort(Comparator.comparing(LegacyJobInfoItemModel::getLastBuildDate));
        }
        return result;
    }

    @NonNull
    private JobInfoModel retrieveOrBuildJobInfoForCurrentUser(@NonNull Map<String, JobInfoModel> jobCache, @NonNull String jobFullName) {
        if (jobCache.containsKey(jobFullName)) {
            return jobCache.get(jobFullName);
        }
        Jenkins jenkins = Jenkins.get();
        boolean hasAccessTo = true;
        Job job = (Job)jenkins.getItem(jobFullName, (ItemGroup)jenkins, Job.class);
        if (job == null) {
            hasAccessTo = false;
            try (ACLContext acl = ACL.as((Authentication)ACL.SYSTEM);){
                job = (Job)jenkins.getItem(jobFullName, (ItemGroup)jenkins, Job.class);
            }
        }
        JobInfoModel jobInfo = new JobInfoModel(job, hasAccessTo, jobFullName);
        jobCache.put(jobFullName, jobInfo);
        return jobInfo;
    }

    public void addLegacyJob(@NonNull Job<?, ?> jobTryingToCopy, @NonNull Job<?, ?> jobToBeCopiedFrom, @NonNull Date lastBuildDate, @NonNull String username) {
        String jobFullNameTo = jobTryingToCopy.getFullName();
        String jobFullNameFrom = jobToBeCopiedFrom.getFullName();
        JobKey key = LegacyMonitorData.buildKey(jobFullNameFrom, jobFullNameTo);
        this.addEntryToKeyMap(jobFullNameFrom, key);
        this.addEntryToKeyMap(jobFullNameTo, key);
        if (this.legacyJobInfos.containsKey(key)) {
            LegacyBuildStorage currentInfo = this.legacyJobInfos.get(key);
            LegacyBuildStorage newInfo = currentInfo.addNewBuild(username, lastBuildDate);
            this.legacyJobInfos.put(key, newInfo);
        } else {
            LegacyBuildStorage info = new LegacyBuildStorage(jobFullNameFrom, jobFullNameTo, username, lastBuildDate);
            this.legacyJobInfos.put(key, info);
        }
    }

    public boolean removeLegacyJob(@NonNull String jobFullNameFrom, @NonNull String jobFullNameTo) {
        JobKey key = LegacyMonitorData.buildKey(jobFullNameFrom, jobFullNameTo);
        if (this.legacyJobInfos.remove(key) == null) {
            return false;
        }
        this.removeEntryFromKeyMap(jobFullNameFrom, key);
        this.removeEntryFromKeyMap(jobFullNameTo, key);
        return true;
    }

    private void addEntryToKeyMap(@NonNull String fullName, @NonNull JobKey key) {
        List<JobKey> fromList = this.fullNameToKey.get(fullName);
        if (fromList == null) {
            fromList = new ArrayList<JobKey>();
            fromList.add(key);
            this.fullNameToKey.put(fullName, fromList);
        } else if (!fromList.contains(key)) {
            fromList.add(key);
        }
    }

    private void removeEntryFromKeyMap(@NonNull String fullName, @NonNull JobKey key) {
        List<JobKey> fromList = this.fullNameToKey.get(fullName);
        if (fromList != null) {
            fromList.remove(key);
            if (fromList.isEmpty()) {
                this.fullNameToKey.remove(fullName);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    static JobKey buildKey(@NonNull String jobFrom, @NonNull String jobTo) {
        return new JobKey(jobFrom, jobTo);
    }

    public static class JobInfoModel {
        private final Job<?, ?> validJob;
        private final boolean regularAccess;
        private final String jobFullName;
        private final boolean autoMigratable;

        public JobInfoModel(@CheckForNull Job<?, ?> validJob, boolean regularAccess, @NonNull String jobFullName) {
            this.validJob = validJob;
            this.regularAccess = regularAccess;
            this.jobFullName = jobFullName;
            this.autoMigratable = LegacyJobConfigMigrationMonitor.canMigrate(validJob);
        }

        @CheckForNull
        public Job<?, ?> getValidJob() {
            return this.validJob;
        }

        public boolean isRegularAccess() {
            return this.regularAccess;
        }

        @NonNull
        public String getJobFullName() {
            return this.jobFullName;
        }

        public boolean isAutoMigratable() {
            return this.autoMigratable;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class LegacyJobInfoItemModel {
        private final JobInfoModel jobTo;
        private final String username;
        private final Date lastBuildDate;
        private final int numOfBuild;

        public LegacyJobInfoItemModel(@NonNull JobInfoModel jobTo, @NonNull String username, @NonNull Date lastBuildDate, int numOfBuild) {
            this.jobTo = jobTo;
            this.username = username;
            this.lastBuildDate = new Date(lastBuildDate.getTime());
            this.numOfBuild = numOfBuild;
        }

        @NonNull
        public JobInfoModel getJobTo() {
            return this.jobTo;
        }

        @NonNull
        public String getUsername() {
            return this.username;
        }

        @NonNull
        public Date getLastBuildDate() {
            return new Date(this.lastBuildDate.getTime());
        }

        public int getNumOfBuild() {
            return this.numOfBuild;
        }
    }

    public static class LegacyBuildInfoModel {
        private final JobInfoModel jobFrom;
        private final List<LegacyJobInfoItemModel> jobToList;

        public LegacyBuildInfoModel(@NonNull JobInfoModel jobFrom) {
            this.jobFrom = jobFrom;
            this.jobToList = new ArrayList<LegacyJobInfoItemModel>();
        }

        @NonNull
        public JobInfoModel getJobFrom() {
            return this.jobFrom;
        }

        public List<LegacyJobInfoItemModel> getJobToList() {
            return this.jobToList;
        }

        public void addItem(LegacyJobInfoItemModel item) {
            this.jobToList.add(item);
        }
    }

    public static class LegacyBuildStorage {
        private final String jobFullNameFrom;
        private final String jobFullNameTo;
        private final String username;
        private final Date lastBuildDate;
        private final int numOfBuild;

        public LegacyBuildStorage(@NonNull String jobFullNameFrom, @NonNull String jobFullNameTo, @NonNull String username, @NonNull Date lastBuildDate) {
            this(jobFullNameFrom, jobFullNameTo, username, lastBuildDate, 1);
        }

        private LegacyBuildStorage(@NonNull String jobFullNameFrom, @NonNull String jobFullNameTo, @NonNull String username, @NonNull Date lastBuildDate, int numOfBuild) {
            this.jobFullNameFrom = jobFullNameFrom;
            this.jobFullNameTo = jobFullNameTo;
            this.username = username;
            this.lastBuildDate = lastBuildDate;
            this.numOfBuild = numOfBuild;
        }

        @NonNull
        public String getJobFullNameFrom() {
            return this.jobFullNameFrom;
        }

        @NonNull
        public String getJobFullNameTo() {
            return this.jobFullNameTo;
        }

        @NonNull
        public String getUsername() {
            return this.username;
        }

        @NonNull
        public Date getLastBuildDate() {
            return new Date(this.lastBuildDate.getTime());
        }

        public int getNumOfBuild() {
            return this.numOfBuild;
        }

        @NonNull
        public LegacyBuildStorage addNewBuild(String username, Date lastBuildDate) {
            return new LegacyBuildStorage(this.jobFullNameFrom, this.jobFullNameTo, username, lastBuildDate, this.numOfBuild + 1);
        }

        public LegacyBuildStorage renameJobFrom(String newJobFullName) {
            return new LegacyBuildStorage(newJobFullName, this.jobFullNameTo, this.username, this.lastBuildDate, this.numOfBuild);
        }

        public LegacyBuildStorage renameJobTo(String newJobFullName) {
            return new LegacyBuildStorage(this.jobFullNameFrom, newJobFullName, this.username, this.lastBuildDate, this.numOfBuild);
        }

        public String toString() {
            return this.jobFullNameFrom + " => " + this.jobFullNameTo;
        }
    }

    public static class JobKey {
        public final String from;
        public final String to;

        public JobKey(@NonNull String from, @NonNull String to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            return this.from.hashCode() * 17 - this.to.hashCode() * 19;
        }

        public boolean equals(@CheckForNull Object obj) {
            if (!(obj instanceof JobKey)) {
                return false;
            }
            JobKey that = (JobKey)obj;
            return this.from.equals(that.from) && this.to.equals(that.to);
        }
    }
}

