/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Extension;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.kohsuke.args4j.Argument;

@Extension
public class GetCredentialsAsXmlCommand
extends BaseCredentialsCLICommand {
    @Argument(metaVar="STORE", usage="Store Id", required=true)
    public CredentialsStore store;
    @Argument(metaVar="DOMAIN", usage="Domain Name", required=true, index=1)
    public String domain;
    @Argument(metaVar="CREDENTIAL", usage="Credential Id", required=true, index=2)
    public String id;

    public String getShortDescription() {
        return Messages.GetCredentialsAsXmlCommand_ShortDescription();
    }

    protected int run() throws Exception {
        this.store.checkPermission(CredentialsProvider.UPDATE);
        Domain domain = GetCredentialsAsXmlCommand.getDomainByName(this.store, this.domain);
        if (domain == null) {
            this.stderr.println("No such domain");
            return 2;
        }
        Credentials existing = GetCredentialsAsXmlCommand.getCredentialsById(this.store, domain, this.id);
        if (existing == null) {
            this.stderr.println("No such credential");
            return 3;
        }
        CredentialsStoreAction.SECRETS_REDACTED.toXML((Object)existing, (Writer)new OutputStreamWriter((OutputStream)this.stdout, "UTF-8"));
        return 0;
    }
}

