/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class Domain
implements Serializable {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    private final String name;
    @CheckForNull
    private final String description;
    @NonNull
    private final List<DomainSpecification> specifications;

    @DataBoundConstructor
    public Domain(String name, String description, List<DomainSpecification> specifications) {
        this.name = Util.fixEmptyAndTrim((String)name);
        this.description = Util.fixEmptyAndTrim((String)description);
        this.specifications = specifications == null ? new ArrayList<DomainSpecification>() : new ArrayList<DomainSpecification>(specifications);
    }

    @NonNull
    public static Domain global() {
        return ResourceHolder.GLOBAL;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.resolve();
    }

    public Domain resolve() {
        if (Util.fixEmptyAndTrim((String)this.name) == null && Util.fixEmptyAndTrim((String)this.description) == null && (this.specifications == null || this.specifications.isEmpty())) {
            return Domain.global();
        }
        return this;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public List<DomainSpecification> getSpecifications() {
        return Collections.unmodifiableList(this.specifications);
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="isGlobal() check implies that domain.getName() is null")
    public String getUrl() {
        return this.isGlobal() ? "domain/_/" : "domain/" + Util.rawEncode((String)this.name) + "/";
    }

    public boolean isGlobal() {
        return this.equals(Domain.global());
    }

    public boolean test(DomainRequirement ... requirements) {
        return this.test(Arrays.asList(requirements));
    }

    public boolean test(@NonNull List<DomainRequirement> requirements) {
        block0: for (DomainRequirement scope : requirements) {
            if (scope == null) continue;
            for (DomainSpecification matcher : this.specifications) {
                DomainSpecification.Result result = matcher.test(scope);
                if (!result.isDefinitive()) continue;
                if (result.isMatch()) continue block0;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain domain = (Domain)o;
        return !(this.name != null ? !this.name.equals(domain.name) : domain.name != null);
    }

    private static final class ResourceHolder {
        private static final Domain GLOBAL = new Domain(null, null, Collections.emptyList());

        private ResourceHolder() {
        }
    }
}

