/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CredentialsParameterDefinition
extends SimpleParameterDefinition {
    private final String defaultValue;
    private final String credentialType;
    private final boolean required;

    @DataBoundConstructor
    public CredentialsParameterDefinition(String name, String description, String defaultValue, String credentialType, boolean required) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.credentialType = credentialType;
        this.required = required;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof CredentialsParameterValue) {
            CredentialsParameterValue value = (CredentialsParameterValue)defaultValue;
            return new CredentialsParameterDefinition(this.getName(), this.getDescription(), value.getValue(), this.getCredentialType(), this.isRequired());
        }
        return this;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        CredentialsParameterValue value = (CredentialsParameterValue)((Object)req.bindJSON(CredentialsParameterValue.class, jo));
        if (this.isRequired() && StringUtils.isBlank((String)value.getValue())) {
            return new CredentialsParameterValue(value.getName(), this.getDefaultValue(), this.getDescription(), true);
        }
        return new CredentialsParameterValue(value.getName(), value.getValue(), this.getDescription(), StringUtils.equals((String)value.getValue(), (String)this.getDefaultValue()));
    }

    public ParameterValue getDefaultParameterValue() {
        return new CredentialsParameterValue(this.getName(), this.getDefaultValue(), this.getDescription(), true);
    }

    public ParameterValue createValue(String value) {
        return new CredentialsParameterValue(this.getName(), value, this.getDescription(), StringUtils.equals((String)value, (String)this.defaultValue));
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Extension
    @Symbol(value={"credentials"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return Messages.CredentialsParameterDefinition_DisplayName();
        }

        public ListBoxModel doFillCredentialTypeItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("Any", StandardCredentials.class.getName());
            for (Descriptor d : CredentialsProvider.allCredentialsDescriptors()) {
                if (!(d instanceof CredentialsDescriptor)) continue;
                CredentialsDescriptor descriptor = (CredentialsDescriptor)d;
                if (!StandardCredentials.class.isAssignableFrom(descriptor.clazz)) continue;
                result.add(descriptor.getDisplayName(), descriptor.clazz.getName());
            }
            return result;
        }

        private Class<? extends StandardCredentials> decodeType(String credentialType) {
            for (Descriptor d : CredentialsProvider.allCredentialsDescriptors()) {
                if (!(d instanceof CredentialsDescriptor)) continue;
                CredentialsDescriptor descriptor = (CredentialsDescriptor)d;
                if (!StandardCredentials.class.isAssignableFrom(descriptor.clazz) || !credentialType.equals(descriptor.clazz.getName())) continue;
                return descriptor.clazz.asSubclass(StandardCredentials.class);
            }
            return StandardCredentials.class;
        }

        private boolean match(Set<Class<? extends StandardCredentials>> allowed, StandardCredentials instance) {
            for (Class<? extends StandardCredentials> b : allowed) {
                if (!b.isInstance(instance)) continue;
                return true;
            }
            return false;
        }

        public StandardListBoxModel doFillDefaultValueItems(@AncestorInPath Item context, @QueryParameter(required=true) String credentialType) {
            Jenkins jenkins = Jenkins.get();
            ACL acl = context == null ? jenkins.getACL() : context.getACL();
            Class<? extends StandardCredentials> typeClass = this.decodeType(credentialType);
            List<DomainRequirement> domainRequirements = Collections.emptyList();
            StandardListBoxModel result = new StandardListBoxModel();
            result.includeEmptyValue();
            if (acl.hasPermission(CredentialsProvider.USE_ITEM)) {
                result.includeAs(CredentialsProvider.getDefaultAuthenticationOf(context), context, typeClass, domainRequirements);
            }
            return result;
        }

        public StandardListBoxModel doFillValueItems(@AncestorInPath Item context, @QueryParameter(required=true) String credentialType, @QueryParameter String value, @QueryParameter boolean required, @QueryParameter boolean includeUser) {
            Jenkins jenkins = Jenkins.get();
            ACL acl = context == null ? jenkins.getACL() : context.getACL();
            Authentication authentication = Jenkins.getAuthentication();
            Authentication itemAuthentication = CredentialsProvider.getDefaultAuthenticationOf(context);
            boolean isSystem = ACL.SYSTEM.equals(authentication);
            Class<? extends StandardCredentials> typeClass = this.decodeType(credentialType);
            List<DomainRequirement> domainRequirements = Collections.emptyList();
            StandardListBoxModel result = new StandardListBoxModel();
            if (!required) {
                result.includeEmptyValue();
            }
            if (!isSystem && acl.hasPermission(CredentialsProvider.USE_OWN) && includeUser) {
                result.includeAs(authentication, context, typeClass, domainRequirements);
            }
            if (acl.hasPermission(CredentialsProvider.USE_ITEM) || isSystem || itemAuthentication.equals(authentication)) {
                result.includeAs(itemAuthentication, context, typeClass, domainRequirements);
            }
            result.includeCurrentValue(value);
            return result;
        }
    }
}

