/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.AbstractCvs;
import hudson.scm.AbstractCvsDescriptor;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.CvsAuthentication;
import hudson.scm.CvsModule;
import hudson.scm.CvsRepository;
import hudson.scm.CvsRepositoryItem;
import hudson.scm.CvsRepositoryLocationType;
import hudson.scm.LegacyConvertor;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.scm.browsers.CvsFacadeRepositoryBrowser;
import hudson.scm.cvstagging.LegacyTagAction;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.netbeans.lib.cvsclient.CVSRoot;

public class CVSSCM
extends AbstractCvs
implements Serializable {
    private static final long serialVersionUID = -2175193493227149541L;
    private final boolean flatten;
    private final CvsRepository[] repositories;
    private final boolean canUseUpdate;
    private final boolean skipChangeLog;
    private boolean pruneEmptyDirectories;
    private boolean disableCvsQuiet;
    private boolean cleanOnFailedUpdate;
    private boolean forceCleanCopy;
    private transient CvsFacadeRepositoryBrowser facadeRepositoryBrowser;
    private boolean checkoutCurrentTimestamp;
    @Deprecated
    private transient String module;
    @Deprecated
    private transient String cvsroot;
    @Deprecated
    private transient String branch;
    @Deprecated
    private transient boolean useHeadIfNotFound;
    @Deprecated
    private transient boolean isTag;
    @Deprecated
    private transient String excludedRegions;
    @Deprecated
    private transient String cvsRsh;
    @Deprecated
    private transient CVSRepositoryBrowser repositoryBrowser;

    @Deprecated
    public CVSSCM(String cvsRoot, String allModules, String branch, String cvsRsh, boolean canUseUpdate, boolean useHeadIfNotFound, boolean legacy, boolean isTag, String excludedRegions) {
        this(cvsRoot, allModules, branch, cvsRsh, canUseUpdate, useHeadIfNotFound, legacy, isTag, excludedRegions, null);
    }

    @Deprecated
    public CVSSCM(String cvsRoot, String allModules, String branch, String cvsRsh, boolean canUseUpdate, boolean useHeadIfNotFound, boolean legacy, boolean isTag, String excludedRegions, CVSRepositoryBrowser browser) {
        this(LegacyConvertor.getInstance().convertLegacyConfigToRepositoryStructure(cvsRoot, allModules, branch, isTag, excludedRegions, useHeadIfNotFound, browser), canUseUpdate, legacy, Boolean.getBoolean(CVSSCM.class.getName() + ".skipChangeLog"), true, false, false, true);
    }

    @Deprecated
    public CVSSCM(List<CvsRepository> repositories, boolean canUseUpdate, boolean legacy, boolean skipChangeLog, boolean pruneEmptyDirectories, boolean disableCvsQuiet, boolean cleanOnFailedUpdate, boolean forceCleanCopy) {
        this(repositories, canUseUpdate, legacy, skipChangeLog, pruneEmptyDirectories, disableCvsQuiet, cleanOnFailedUpdate, forceCleanCopy, false);
    }

    @DataBoundConstructor
    public CVSSCM(List<CvsRepository> repositories, boolean canUseUpdate, boolean legacy, boolean skipChangeLog, boolean pruneEmptyDirectories, boolean disableCvsQuiet, boolean cleanOnFailedUpdate, boolean forceCleanCopy, boolean checkoutCurrentTimestamp) {
        this.repositories = repositories.toArray(new CvsRepository[repositories.size()]);
        this.canUseUpdate = canUseUpdate;
        this.skipChangeLog = skipChangeLog;
        this.flatten = !legacy && this.repositories.length == 1 && this.repositories[0].getRepositoryItems().length == 1 && this.repositories[0].getRepositoryItems()[0].getModules().length == 1;
        this.pruneEmptyDirectories = pruneEmptyDirectories;
        this.disableCvsQuiet = disableCvsQuiet;
        this.cleanOnFailedUpdate = cleanOnFailedUpdate;
        this.forceCleanCopy = forceCleanCopy;
        this.checkoutCurrentTimestamp = checkoutCurrentTimestamp;
    }

    public final Object readResolve() {
        if (this.repositoryBrowser != null) {
            this.facadeRepositoryBrowser = new CvsFacadeRepositoryBrowser(this.repositoryBrowser);
            if (this.repositories != null) {
                ArrayList<CvsRepository> newRepositories = new ArrayList<CvsRepository>();
                for (CvsRepository repository : this.repositories) {
                    newRepositories.add(new CvsRepository(repository.getCvsRoot(), repository.isPasswordRequired(), repository.getPassword().getPlainText(), Arrays.asList(repository.getRepositoryItems()), Arrays.asList(repository.getExcludedRegions()), repository.getCompressionLevel(), this.repositoryBrowser));
                }
                return new CVSSCM(Arrays.asList(this.repositories), this.isCanUseUpdate(), this.isLegacy(), this.isSkipChangeLog(), this.isPruneEmptyDirectories(), this.isDisableCvsQuiet(), this.isCleanOnFailedUpdate(), this.isForceCleanCopy());
            }
        }
        if (null != this.repositories) {
            return this;
        }
        return new CVSSCM(this.cvsroot, this.module, this.branch, this.cvsRsh, this.isCanUseUpdate(), this.useHeadIfNotFound, this.isLegacy(), this.isTag, this.excludedRegions, this.repositoryBrowser);
    }

    @Override
    @Exported
    public CvsRepository[] getRepositories() {
        return this.repositories;
    }

    public CvsFacadeRepositoryBrowser getBrowser() {
        if (this.facadeRepositoryBrowser == null) {
            return new CvsFacadeRepositoryBrowser();
        }
        return this.facadeRepositoryBrowser;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return super.compareRemoteRevisionWith(project, launcher, workspace, listener, baseline, this.getRepositories());
    }

    public FilePath getModuleRoot(FilePath workspace, AbstractBuild build) {
        if (this.flatten) {
            return workspace;
        }
        return workspace.child(this.getRepositories()[0].getRepositoryItems()[0].getModules()[0].getCheckoutName());
    }

    public FilePath[] getModuleRoots(FilePath workspace, AbstractBuild build) {
        if (!this.flatten) {
            ArrayList<FilePath> moduleRoots = new ArrayList<FilePath>();
            for (CvsRepository repository : this.getRepositories()) {
                for (CvsRepositoryItem item : repository.getRepositoryItems()) {
                    for (CvsModule module : item.getModules()) {
                        moduleRoots.add(workspace.child(module.getCheckoutName()));
                    }
                }
            }
            return moduleRoots.toArray(new FilePath[moduleRoots.size()]);
        }
        return new FilePath[]{this.getModuleRoot(workspace, build)};
    }

    @Override
    @Exported
    public boolean isCanUseUpdate() {
        return this.canUseUpdate;
    }

    @Override
    @Exported
    public boolean isSkipChangeLog() {
        return this.skipChangeLog;
    }

    @Override
    @Exported
    public boolean isPruneEmptyDirectories() {
        return this.pruneEmptyDirectories;
    }

    @Override
    @Exported
    public boolean isFlatten() {
        return this.flatten;
    }

    @Override
    @Exported
    public boolean isDisableCvsQuiet() {
        return this.disableCvsQuiet;
    }

    @Override
    @Exported
    public boolean isCleanOnFailedUpdate() {
        return this.cleanOnFailedUpdate;
    }

    @Override
    @Exported
    public boolean isForceCleanCopy() {
        return this.forceCleanCopy;
    }

    public boolean isLegacy() {
        return !this.flatten;
    }

    @Override
    @Exported
    public boolean isCheckoutCurrentTimestamp() {
        return this.checkoutCurrentTimestamp;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        String branchName = this.getBranchName();
        if (branchName != null) {
            env.put("CVS_BRANCH", branchName);
        }
    }

    private String getBranchName() {
        if (this.getRepositories()[0].getRepositoryItems()[0].getLocation().getLocationType() == CvsRepositoryLocationType.HEAD) {
            return null;
        }
        String locationName = this.getRepositories()[0].getRepositoryItems()[0].getLocation().getLocationName();
        if (null == locationName) {
            return null;
        }
        for (CvsRepository repository : this.getRepositories()) {
            for (CvsRepositoryItem item : repository.getRepositoryItems()) {
                if (locationName.equals(item.getLocation().getLocationName())) continue;
                return null;
            }
        }
        return locationName;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        try {
            this.checkout((Run<?, ?>)build, launcher, workspace, (TaskListener)listener, changelogFile, null);
        }
        catch (AbortException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(@NonNull Run<?, ?> build, @NonNull Launcher launcher, @NonNull FilePath workspace, @NonNull TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        String dateStamp;
        if (!this.canUseUpdate) {
            workspace.deleteContents();
        }
        Date checkoutDate = this.getCheckoutDate(build);
        DateFormat dateFormat = DATE_FORMATTER;
        synchronized (dateFormat) {
            dateStamp = DATE_FORMATTER.format(checkoutDate);
        }
        if (!this.checkout(this.repositories, this.flatten, workspace, this.canUseUpdate, build, dateStamp, this.pruneEmptyDirectories, this.cleanOnFailedUpdate, listener)) {
            throw new AbortException();
        }
        this.postCheckout(build, changelogFile, this.getRepositories(), workspace, listener, this.isFlatten(), build.getEnvironment(listener));
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractCvsDescriptor<CVSSCM>
    implements ModelObject {
        private transient String cvsPassFile;
        private transient String cvsExe;
        private transient boolean noCompression;
        private transient Map<String, RepositoryBrowser> browsers;
        private int compressionLevel = 3;
        private String privateKeyLocation = System.getProperty("user.home") + "/.ssh/id_rsa";
        private Secret privateKeyPassword = null;
        private String knownHostsLocation = System.getProperty("user.home") + "/.ssh/known_hosts";
        private CvsAuthentication[] authTokens = new CvsAuthentication[0];
        private String changelogEncoding = "UTF-8";

        @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="Jenkins relies on calling overridable methods from constructors")
        public DescriptorImpl() {
            super(CVSRepositoryBrowser.class);
            this.load();
        }

        public List<Descriptor<hudson.scm.RepositoryBrowser<?>>> getBrowserDescriptors() {
            List browsers = super.getBrowserDescriptors();
            Iterator itr = browsers.iterator();
            while (itr.hasNext()) {
                if (((Descriptor)itr.next()).getClass() != CvsFacadeRepositoryBrowser.CvsFacadeRepositoryBrowserDescriptor.class) continue;
                itr.remove();
            }
            return browsers;
        }

        public String getDisplayName() {
            return "CVS";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SCM)req.bindJSON(CVSSCM.class, formData);
        }

        @Override
        @Exported
        public String getPrivateKeyLocation() {
            return this.privateKeyLocation;
        }

        @Override
        @Exported
        public Secret getPrivateKeyPassword() {
            return this.privateKeyPassword;
        }

        @Override
        @Exported
        public String getKnownHostsLocation() {
            return this.knownHostsLocation;
        }

        @Override
        @Exported
        public int getCompressionLevel() {
            return this.compressionLevel;
        }

        @Override
        @Exported
        public CvsAuthentication[] getAuthentication() {
            return this.authTokens;
        }

        @Override
        @Exported
        public String getChangelogEncoding() {
            return this.changelogEncoding;
        }

        public void load() {
            super.load();
            if (this.noCompression) {
                this.compressionLevel = 0;
            }
        }

        public boolean configure(StaplerRequest req, JSONObject o) {
            String compressionLevel = Util.fixEmptyAndTrim((String)o.getString("cvsCompression"));
            try {
                this.compressionLevel = Integer.parseInt(compressionLevel);
            }
            catch (NumberFormatException ex) {
                this.compressionLevel = 0;
            }
            String knownHostsLocation = Util.fixEmptyAndTrim((String)o.getString("knownHostsLocation"));
            this.knownHostsLocation = knownHostsLocation == null ? System.getProperty("user.home") + "/.ssh/known_hosts" : knownHostsLocation;
            String privateKeyLocation = Util.fixEmptyAndTrim((String)o.getString("privateKeyLocation"));
            this.privateKeyLocation = privateKeyLocation == null ? System.getProperty("user.home") + "/.ssh/id_rsa" : privateKeyLocation;
            this.privateKeyPassword = Secret.fromString((String)Util.fixEmptyAndTrim((String)o.getString("privateKeyPassword")));
            List authTokens = req.bindParametersToList(CvsAuthentication.class, "cvsAuthentication.");
            this.authTokens = authTokens.toArray(new CvsAuthentication[authTokens.size()]);
            this.save();
            return true;
        }

        public Set<String> getAllCvsRoots() {
            TreeSet<String> r = new TreeSet<String>();
            for (AbstractProject p : Jenkins.get().getAllItems(AbstractProject.class)) {
                SCM scm = p.getScm();
                if (!(scm instanceof CVSSCM)) continue;
                CVSSCM cvsscm = (CVSSCM)scm;
                for (CvsRepository repository : cvsscm.getRepositories()) {
                    r.add(repository.getCvsRoot());
                }
            }
            return r;
        }

        @Deprecated
        public String getCvsPassFile() {
            return this.cvsPassFile;
        }

        public FormValidation doCheckAuthenticationCvsRoot(@QueryParameter String value) {
            try {
                CVSRoot cvsRoot = CVSRoot.parse((String)value);
                if (cvsRoot.getUserName() != null) {
                    return FormValidation.error((String)"Do not specify a username in the CVS root; use the username field.");
                }
                if (cvsRoot.getPassword() != null) {
                    return FormValidation.error((String)"Do not specify a password in the CVS root; use the password field.");
                }
                if (cvsRoot.getMethod().equals("fork") || cvsRoot.getMethod().equals("local")) {
                    return FormValidation.error((String)(cvsRoot.getMethod() + " does not support authentication so should not be specified"));
                }
                return FormValidation.ok();
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((String)(value + " does not seem to be a valid CVS root so would not match any repositories."));
            }
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public static DescriptorImpl getOrDie() {
            return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(CVSSCM.class);
        }

        private class RepositoryBrowser {
            transient String diffURL;
            transient String browseURL;

            private RepositoryBrowser() {
            }
        }
    }

    @Deprecated
    public final class TagAction
    extends AbstractScmTagAction
    implements Describable<TagAction> {
        private String tagName;

        public TagAction(Run<?, ?> build) {
            super(build);
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public Descriptor<TagAction> getDescriptor() {
            return null;
        }

        public boolean isTagged() {
            return false;
        }

        public Object readResolve() throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
            LegacyTagAction legacyTagAction = new LegacyTagAction((Run<?, ?>)this.build, CVSSCM.this);
            Field tagNameField = ((Object)((Object)legacyTagAction)).getClass().getDeclaredField("tagName");
            tagNameField.setAccessible(true);
            tagNameField.set((Object)legacyTagAction, this.tagName);
            return legacyTagAction;
        }
    }
}

