/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.scm.CvsModule;
import hudson.scm.CvsRepositoryLocation;
import java.io.Serializable;
import java.util.Arrays;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class CvsRepositoryItem
implements Describable<CvsRepositoryItem>,
Serializable {
    private CvsModule[] modules;
    private CvsRepositoryLocation location;

    @DataBoundConstructor
    public CvsRepositoryItem(CvsRepositoryLocation location, CvsModule[] modules) {
        this.location = location;
        this.modules = modules;
    }

    @Exported
    public CvsModule[] getModules() {
        return this.modules;
    }

    @Exported
    public CvsRepositoryLocation getLocation() {
        return this.location;
    }

    public CvsRepositoryItemDescriptor getDescriptor() {
        return (CvsRepositoryItemDescriptor)Jenkins.getActiveInstance().getDescriptorOrDie(CvsRepositoryItem.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvsRepositoryItem that = (CvsRepositoryItem)o;
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        return Arrays.equals(this.modules, that.modules);
    }

    public int hashCode() {
        int result = this.modules != null ? Arrays.hashCode(this.modules) : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        return result;
    }

    @Extension
    public static class CvsRepositoryItemDescriptor
    extends Descriptor<CvsRepositoryItem> {
        public String getDisplayName() {
            return "CVS Repository Item";
        }

        public DescriptorExtensionList<CvsRepositoryLocation, CvsRepositoryLocation.CvsRepositoryLocationDescriptor> getRepositoryLocationDescriptorList() {
            return Jenkins.getActiveInstance().getDescriptorList(CvsRepositoryLocation.class);
        }
    }
}

