/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.scm.AbstractCvs;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.CvsRepository;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;

public class CvsFacadeRepositoryBrowser
extends CVSRepositoryBrowser {
    private final CVSRepositoryBrowser legacyBrowser;
    private final transient Map<CVSChangeLogSet.CVSChangeLog, CVSRepositoryBrowser> changeToBrowserMap = new HashMap<CVSChangeLogSet.CVSChangeLog, CVSRepositoryBrowser>();

    public CvsFacadeRepositoryBrowser(CVSRepositoryBrowser legacyBrowser) {
        this.legacyBrowser = legacyBrowser;
    }

    public CvsFacadeRepositoryBrowser() {
        this(null);
    }

    @Override
    public URL getDiffLink(CVSChangeLogSet.File file) throws IOException {
        CVSRepositoryBrowser browser = this.resolveRepositoryBrowser(file.getParent());
        if (null == browser) {
            return null;
        }
        return this.resolveRepositoryBrowser(file.getParent()).getDiffLink(file);
    }

    @Override
    public URL getFileLink(CVSChangeLogSet.File file) throws IOException {
        CVSRepositoryBrowser browser = this.resolveRepositoryBrowser(file.getParent());
        if (null == browser) {
            return null;
        }
        return this.resolveRepositoryBrowser(file.getParent()).getFileLink(file);
    }

    public URL getChangeSetLink(CVSChangeLogSet.CVSChangeLog changeSet) throws IOException {
        CVSRepositoryBrowser browser = this.resolveRepositoryBrowser(changeSet);
        if (browser == null) {
            return null;
        }
        return browser.getChangeSetLink(changeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CVSRepositoryBrowser resolveRepositoryBrowser(CVSChangeLogSet.CVSChangeLog changelog) {
        Map<CVSChangeLogSet.CVSChangeLog, CVSRepositoryBrowser> map = this.changeToBrowserMap;
        synchronized (map) {
            if (!this.changeToBrowserMap.containsKey(changelog)) {
                this.changeToBrowserMap.put(changelog, this.calculateRepositoryBrowser(changelog));
            }
        }
        return this.changeToBrowserMap.get(changelog);
    }

    private CVSRepositoryBrowser calculateRepositoryBrowser(CVSChangeLogSet.CVSChangeLog changelog) {
        if (changelog.getRepository() == null) {
            return this.legacyBrowser;
        }
        CVSRepositoryBrowser browser = changelog.getRepository().getRepositoryBrowser();
        if (browser != null) {
            return browser;
        }
        for (AbstractProject p : Jenkins.getActiveInstance().getAllItems(AbstractProject.class)) {
            SCM scm = p.getScm();
            if (!(scm instanceof AbstractCvs)) continue;
            AbstractCvs cvs = (AbstractCvs)scm;
            for (CvsRepository repository : cvs.getRepositories()) {
                if (repository.getRepositoryBrowser() == null || !CvsFacadeRepositoryBrowser.equals(CVSRoot.parse((String)repository.getCvsRoot()), CVSRoot.parse((String)changelog.getRepository().getCvsRoot()))) continue;
                return repository.getRepositoryBrowser();
            }
        }
        return null;
    }

    private static boolean equals(CVSRoot root1, CVSRoot root2) {
        return CvsFacadeRepositoryBrowser.toString(root1).equals(CvsFacadeRepositoryBrowser.toString(root2));
    }

    private static String toString(CVSRoot root) {
        if (root.getHostName() == null) {
            if (root.getMethod() == null) {
                return root.getRepository();
            }
            return ":" + root.getMethod() + ":" + root.getRepository();
        }
        StringBuilder buf = new StringBuilder();
        if (root.getMethod() != null) {
            buf.append(':');
            buf.append(root.getMethod());
            buf.append(':');
        }
        buf.append(root.getHostName());
        buf.append(':');
        Connection connection = ConnectionFactory.getConnection((CVSRoot)root);
        if (connection.getPort() > 0) {
            buf.append(connection.getPort());
        }
        buf.append(root.getRepository());
        return buf.toString();
    }

    @Extension
    public static class CvsFacadeRepositoryBrowserDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Cvs Facade Repository Browser";
        }
    }
}

