/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.cvstagging;

import hudson.model.AbstractBuild;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.scm.AbstractCvs;
import hudson.scm.CvsFile;
import hudson.scm.CvsRepository;
import hudson.scm.CvsRevisionState;
import hudson.scm.cvstagging.CvsTagAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.RtagCommand;
import org.netbeans.lib.cvsclient.commandLine.BasicListener;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class CvsTagActionWorker
extends TaskThread {
    private final CvsRevisionState revisionState;
    private final String tagName;
    private final AbstractBuild<?, ?> build;
    private final CvsTagAction parent;
    private final boolean createBranch;
    private final boolean moveTag;
    private boolean isSuccess = true;

    public CvsTagActionWorker(CvsRevisionState revisionState, String tagName, boolean createBranch, AbstractBuild<?, ?> build, CvsTagAction parent, boolean moveTag) {
        super((TaskAction)parent, TaskThread.ListenerAndText.forMemory((TaskAction)parent));
        this.revisionState = revisionState;
        this.tagName = tagName;
        this.build = build;
        this.parent = parent;
        this.createBranch = createBranch;
        this.moveTag = moveTag;
    }

    public void perform(TaskListener listener) throws IOException, InterruptedException, CommandException, AuthenticationException {
        for (CvsRepository repository : this.revisionState.getModuleFiles().keySet()) {
            boolean oneIterationComplete = false;
            HashMap<String, ArrayList<String>> versionFileMap = new HashMap<String, ArrayList<String>>();
            for (CvsFile cvsFile : this.revisionState.getModuleState(repository)) {
                ArrayList<String> filesForVersion = (ArrayList<String>)versionFileMap.get(cvsFile.getRevision());
                if (null == filesForVersion) {
                    filesForVersion = new ArrayList<String>();
                    versionFileMap.put(cvsFile.getRevision(), filesForVersion);
                }
                filesForVersion.add(cvsFile.getName());
            }
            for (Map.Entry entry : versionFileMap.entrySet()) {
                AbstractCvs owner = this.parent.getParent();
                Client cvsClient = owner.getCvsClient(repository, this.build.getEnvironment(listener), listener, !oneIterationComplete);
                GlobalOptions globalOptions = owner.getGlobalOptions(repository, this.build.getEnvironment(listener));
                globalOptions.setCVSRoot(repository.getCvsRoot());
                RtagCommand rtagCommand = new RtagCommand();
                rtagCommand.setTag(this.tagName);
                rtagCommand.setTagByRevision((String)entry.getKey());
                for (String fileName : (List)entry.getValue()) {
                    rtagCommand.addModule(fileName);
                }
                rtagCommand.setMakeBranchTag(this.createBranch);
                rtagCommand.setOverrideExistingTag(this.moveTag);
                cvsClient.getEventManager().addCVSListener((CVSListener)new BasicListener(listener.getLogger(), listener.getLogger()));
                try {
                    this.isSuccess = this.isSuccess && cvsClient.executeCommand((Command)rtagCommand, globalOptions);
                }
                catch (CommandAbortedException e) {
                    e.printStackTrace(listener.error("The CVS rtag command was aborted"));
                    throw e;
                }
                catch (CommandException e) {
                    e.printStackTrace(listener.error("Error while trying to run CVS rtag command"));
                    throw e;
                }
                catch (AuthenticationException e) {
                    e.printStackTrace(listener.error("Authentication error while trying to run CVS rtag command"));
                    throw e;
                }
                finally {
                    try {
                        cvsClient.getConnection().close();
                    }
                    catch (IOException ex) {
                        listener.error("Could not close client connection: " + ex.getMessage());
                    }
                }
                oneIterationComplete = true;
            }
        }
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }
}

