/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerRegistryEndpoint
extends AbstractDescribableImpl<DockerRegistryEndpoint> {
    private static final Pattern DOCKER_REGISTRY_PATTERN = Pattern.compile("(([^/]+\\.[^/]+)/)?(([a-z0-9_]+)/)?([a-zA-Z0-9-_\\.]+)(:([a-z0-9-_\\.]+))?");
    private final String url;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public DockerRegistryEndpoint(String url, String credentialsId) {
        this.url = Util.fixEmpty((String)url);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public static DockerRegistryEndpoint fromImageName(String s, @CheckForNull String credentialsId) {
        String url;
        Matcher matcher = DOCKER_REGISTRY_PATTERN.matcher(s);
        if (!matcher.matches() || matcher.groupCount() < 7) {
            throw new IllegalArgumentException(s + " does not match regex " + DOCKER_REGISTRY_PATTERN);
        }
        try {
            url = matcher.group(2) == null ? null : new URL("https://" + matcher.group(2)).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(s + " can not be parsed as URL: " + e.getMessage());
        }
        return new DockerRegistryEndpoint(url, credentialsId);
    }

    @Nonnull
    public URL getEffectiveUrl() throws IOException {
        if (this.url != null) {
            return new URL(this.url);
        }
        return new URL("https://index.docker.io/v1/");
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public DockerRegistryToken getToken(Item context) {
        if (this.credentialsId == null) {
            return null;
        }
        List<Object> requirements = Collections.emptyList();
        try {
            requirements = Collections.singletonList(new HostnameRequirement(this.getEffectiveUrl().getHost()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (DockerRegistryToken)AuthenticationTokens.convert(DockerRegistryToken.class, (Credentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(IdCredentials.class, (Item)context, (Authentication)Jenkins.getAuthentication(), requirements), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(DockerRegistryToken.class), CredentialsMatchers.withId((String)this.credentialsId)})));
    }

    @Deprecated
    public KeyMaterialFactory newKeyMaterialFactory(@Nonnull AbstractBuild build) throws IOException, InterruptedException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IllegalStateException("Requires workspace.");
        }
        return this.newKeyMaterialFactory((Item)build.getParent(), workspace.getChannel());
    }

    @Deprecated
    public KeyMaterialFactory newKeyMaterialFactory(Item context, @Nonnull VirtualChannel target) throws IOException, InterruptedException {
        return this.newKeyMaterialFactory(context, target, null, TaskListener.NULL);
    }

    public KeyMaterialFactory newKeyMaterialFactory(@CheckForNull Item context, @Nonnull VirtualChannel target, @CheckForNull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        if (this.credentialsId == null) {
            return KeyMaterialFactory.NULL;
        }
        DockerRegistryToken token = this.getToken(context);
        if (token == null) {
            throw new AbortException("Could not find credentials matching " + this.credentialsId);
        }
        return token.newKeyMaterialFactory(this.getEffectiveUrl(), target, launcher, listener);
    }

    public String imageName(@Nonnull String userAndRepo) throws IOException {
        if (userAndRepo == null) {
            throw new IllegalArgumentException("Image name cannot be null.");
        }
        if (this.url == null) {
            return userAndRepo;
        }
        URL effectiveUrl = this.getEffectiveUrl();
        StringBuilder s = new StringBuilder(effectiveUrl.getHost());
        if (effectiveUrl.getPort() > 0) {
            s.append(':').append(effectiveUrl.getPort());
        }
        if (userAndRepo.startsWith(String.valueOf(s))) {
            return userAndRepo;
        }
        return s.append('/').append(userAndRepo).toString();
    }

    public String toString() {
        return "DockerRegistryEndpoint[" + this.url + ";credentialsId=" + this.credentialsId + "]";
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (this.url != null ? this.url.hashCode() : 0);
        hash = 31 * hash + (this.credentialsId != null ? this.credentialsId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DockerRegistryEndpoint other = (DockerRegistryEndpoint)((Object)obj);
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.credentialsId == null ? other.credentialsId != null : !this.credentialsId.equals(other.credentialsId));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerRegistryEndpoint> {
        public String getDisplayName() {
            return "Docker Hub";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item) {
            if (item == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withMatching(AuthenticationTokens.matcher(DockerRegistryToken.class), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)item, null, Collections.emptyList()));
        }
    }
}

