/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;

public final class DockerRegistryToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String email;
    private final String token;

    public DockerRegistryToken(String email, String token) {
        this.email = email;
        this.token = token;
    }

    public String getEmail() {
        return this.email;
    }

    public String getToken() {
        return this.token;
    }

    @Deprecated
    public KeyMaterialFactory newKeyMaterialFactory(URL endpoint, @Nonnull VirtualChannel target) throws InterruptedException, IOException {
        return this.newKeyMaterialFactory(endpoint, target, null, TaskListener.NULL);
    }

    public KeyMaterialFactory newKeyMaterialFactory(final @Nonnull URL endpoint, @Nonnull VirtualChannel target, @CheckForNull Launcher launcher, final @Nonnull TaskListener listener) throws InterruptedException, IOException {
        target.call((Callable)new MasterToSlaveCallable<Void, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void call() throws IOException {
                Class<DockerRegistryToken> clazz = DockerRegistryToken.class;
                synchronized (DockerRegistryToken.class) {
                    JSONObject auths;
                    JSONObject json;
                    File config = new File(System.getProperty("user.home"), ".docker/config.json");
                    if (config.exists()) {
                        json = JSONObject.fromObject((Object)FileUtils.readFileToString((File)config, (String)"UTF-8"));
                        auths = json.getJSONObject("auths");
                    } else {
                        config = new File(System.getProperty("user.home"), ".dockercfg");
                        auths = config.exists() ? (json = JSONObject.fromObject((Object)FileUtils.readFileToString((File)config, (String)"UTF-8"))) : (json = new JSONObject());
                    }
                    auths.put(endpoint.toString(), (Object)new JSONObject().accumulate("auth", (Object)DockerRegistryToken.this.getToken()).accumulate("email", (Object)DockerRegistryToken.this.getEmail()));
                    FileUtils.writeStringToFile((File)config, (String)json.toString(2), (String)"UTF-8");
                    listener.getLogger().println("Wrote authentication to " + config);
                    // ** MonitorExit[var3_1] (shouldn't be in output)
                    return null;
                }
            }
        });
        return KeyMaterialFactory.NULL;
    }
}

