/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerServerCredentials
extends BaseStandardCredentials {
    @CheckForNull
    private final Secret clientKey;
    @CheckForNull
    private final String clientCertificate;
    @CheckForNull
    private final String serverCaCertificate;

    @DataBoundConstructor
    public DockerServerCredentials(CredentialsScope scope, String id, String description, @CheckForNull String clientKey, @CheckForNull String clientCertificate, @CheckForNull String serverCaCertificate) {
        super(scope, id, description);
        this.clientKey = Util.fixEmptyAndTrim((String)clientKey) == null ? null : Secret.fromString((String)clientKey);
        this.clientCertificate = Util.fixEmptyAndTrim((String)clientCertificate);
        this.serverCaCertificate = Util.fixEmptyAndTrim((String)serverCaCertificate);
    }

    @CheckForNull
    public String getClientKey() {
        return this.clientKey == null ? null : this.clientKey.getPlainText();
    }

    @CheckForNull
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @CheckForNull
    public String getServerCaCertificate() {
        return this.serverCaCertificate;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Docker Host Certificate Authentication";
        }
    }
}

