/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.remoting.VirtualChannel;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerDomainRequirement;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialContext;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.jenkinsci.plugins.docker.commons.impl.ServerHostKeyMaterialFactory;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DockerServerEndpoint
extends AbstractDescribableImpl<DockerServerEndpoint> {
    private static final Class<DockerServerCredentials> BASE_CREDENTIAL_TYPE = DockerServerCredentials.class;
    private final String uri;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public DockerServerEndpoint(String uri, String credentialsId) {
        this.uri = Util.fixEmpty((String)uri);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @Nullable
    public String getUri() {
        return this.uri;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public KeyMaterialFactory newKeyMaterialFactory(@Nonnull AbstractBuild build) throws IOException, InterruptedException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IllegalStateException("Build has no workspace");
        }
        return this.newKeyMaterialFactory((Item)build.getParent(), workspace.getChannel());
    }

    public KeyMaterialFactory newKeyMaterialFactory(@Nonnull Item context, @Nonnull VirtualChannel target) throws IOException, InterruptedException {
        DockerServerCredentials creds = null;
        if (this.credentialsId != null) {
            List domainRequirements = URIRequirementBuilder.fromUri((String)this.getUri()).build();
            domainRequirements.add(new DockerServerDomainRequirement());
            creds = (DockerServerCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(DockerServerCredentials.class, (Item)context, (Authentication)Jenkins.getAuthentication(), (List)domainRequirements), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
        }
        FilePath dotDocker = DockerServerEndpoint.dotDocker(target);
        dotDocker.mkdirs();
        return this.newKeyMaterialFactory(dotDocker, creds);
    }

    static FilePath dotDocker(@Nonnull VirtualChannel target) throws IOException, InterruptedException {
        return FilePath.getHomeDirectory((VirtualChannel)target).child(".docker");
    }

    public KeyMaterialFactory newKeyMaterialFactory(FilePath dir, @Nullable DockerServerCredentials credentials) throws IOException, InterruptedException {
        return (this.uri == null ? KeyMaterialFactory.NULL : new ServerHostKeyMaterialFactory(this.uri)).plus((KeyMaterialFactory)AuthenticationTokens.convert(KeyMaterialFactory.class, (Credentials)credentials)).contextualize(new KeyMaterialContext(dir));
    }

    public String toString() {
        return "DockerServerEndpoint[" + this.uri + ";credentialsId=" + this.credentialsId + "]";
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 13 * hash + (this.credentialsId != null ? this.credentialsId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DockerServerEndpoint other = (DockerServerEndpoint)((Object)obj);
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return !(this.credentialsId == null ? other.credentialsId != null : !this.credentialsId.equals(other.credentialsId));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerServerEndpoint> {
        public String getDisplayName() {
            return "Docker Daemon";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String uri) {
            if (item == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel();
            }
            List domainRequirements = URIRequirementBuilder.fromUri((String)uri).build();
            domainRequirements.add(new DockerServerDomainRequirement());
            return new StandardListBoxModel().withEmptySelection().withMatching(AuthenticationTokens.matcher(KeyMaterialFactory.class), (Iterable)CredentialsProvider.lookupCredentials((Class)BASE_CREDENTIAL_TYPE, (Item)item, null, (List)domainRequirements));
        }
    }
}

