/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import jakarta.mail.internet.InternetAddress;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.scm.RunWithSCM;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class PreviousRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public PreviousRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        HashSet<User> users = new HashSet<User>();
        for (Run build = context.getRun().getPreviousCompletedBuild(); users.isEmpty() && build != null; build = build.getPreviousCompletedBuild()) {
            if (build instanceof RunWithSCM) {
                RunWithSCM cM = (RunWithSCM)build;
                users.addAll(cM.getCulprits());
            }
            users.addAll(RecipientProviderUtilities.getChangeSetAuthors(Collections.singleton(build), debug));
            users.addAll(RecipientProviderUtilities.getUsersTriggeringTheBuilds(Collections.singleton(build), debug));
        }
        RecipientProviderUtilities.addUsers(users, context, env, to, cc, bcc, (RecipientProviderUtilities.IDebug)debug);
    }

    @Extension
    @Symbol(value={"previous"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.PreviousRecipientProvider_DisplayName();
        }
    }
}

