/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.envinject.EnvInjectInfo;
import org.jenkinsci.plugins.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.Messages;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVarsUnset;
import org.jenkinsci.plugins.envinject.service.PropertiesVariablesRetriever;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectBuilder
extends Builder
implements Serializable {
    private EnvInjectInfo info;

    public EnvInjectInfo getInfo() {
        return this.info;
    }

    public void setInfo(EnvInjectInfo info) {
        this.info = info;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath ws = build.getWorkspace();
        EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(ws);
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        try {
            Map<String, String> variables = envInjectActionSetter.getCurrentEnvVars(build);
            variables.putAll(this.getAndAddBuildVariables(build));
            Map envMap = (Map)ws.act((FilePath.FileCallable)new PropertiesVariablesRetriever(this.info, variables, new EnvInjectLogger((TaskListener)listener)));
            variables.putAll(envMap);
            EnvVars.resolve(variables);
            final Map<String, String> resultVariables = new EnvInjectEnvVarsUnset(logger).removeUnsetVars(variables);
            build.addAction((Action)new EnvironmentContributingAction(){

                public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
                    env.putAll(resultVariables);
                }

                public String getIconFileName() {
                    return null;
                }

                public String getDisplayName() {
                    return null;
                }

                public String getUrlName() {
                    return null;
                }
            });
            envInjectActionSetter.addEnvVarsToEnvInjectBuildAction(build, resultVariables);
        }
        catch (Throwable throwable) {
            logger.error("[EnvInject] - [ERROR] - Problems occurs on injecting env vars as a build step: " + throwable.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    private Map<String, String> getAndAddBuildVariables(AbstractBuild build) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(build.getBuildVariables());
        FilePath ws = build.getWorkspace();
        if (ws != null) {
            result.put("WORKSPACE", ws.getRemote());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Messages.envinject_addVars_displayName();
        }

        public EnvInjectBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            EnvInjectBuilder envInjectBuilder = new EnvInjectBuilder();
            EnvInjectInfo info = new EnvInjectInfo(formData.getString("propertiesFilePath"), formData.getString("propertiesContent"), false);
            envInjectBuilder.setInfo(info);
            return envInjectBuilder;
        }

        public String getHelpFile() {
            return "/plugin/envinject/help-buildStep.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

