/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.envinject.EnvInjectAction;
import org.jenkinsci.plugins.envinject.EnvInjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectActionSetter
implements Serializable {
    private FilePath rootPath;

    public EnvInjectActionSetter(FilePath rootPath) {
        this.rootPath = rootPath;
    }

    public void addEnvVarsToEnvInjectBuildAction(AbstractBuild<?, ?> build, Map<String, String> envMap) throws EnvInjectException, IOException, InterruptedException {
        EnvInjectAction envInjectAction = (EnvInjectAction)build.getAction(EnvInjectAction.class);
        if (envInjectAction != null) {
            envInjectAction.overrideAll(envMap);
        } else {
            envInjectAction = new EnvInjectAction((Map)this.rootPath.act((Callable)new Callable<Map<String, String>, EnvInjectException>(){

                public Map<String, String> call() throws EnvInjectException {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.putAll(EnvVars.masterEnvVars);
                    return result;
                }
            }));
            envInjectAction.overrideAll(envMap);
            build.addAction((Action)envInjectAction);
        }
    }

    public Map<String, String> getCurrentEnvVars(AbstractBuild<?, ?> build) {
        EnvInjectAction envInjectAction = (EnvInjectAction)build.getAction(EnvInjectAction.class);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (envInjectAction != null) {
            Map<String, String> envMap = envInjectAction.getEnvMap();
            result.putAll(envMap);
            return result;
        }
        return result;
    }
}

