/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectScriptExecutorService {
    private EnvInjectJobPropertyInfo info;
    private Map<String, String> currentEnvVars;
    private FilePath rootScriptExecutionPath;
    private Launcher launcher;
    private EnvInjectLogger logger;

    public EnvInjectScriptExecutorService(EnvInjectJobPropertyInfo info, Map<String, String> currentEnvVars, FilePath rootScriptExecutionPath, Launcher launcher, EnvInjectLogger logger) {
        this.info = info;
        this.currentEnvVars = currentEnvVars;
        this.rootScriptExecutionPath = rootScriptExecutionPath;
        this.launcher = launcher;
        this.logger = logger;
    }

    public void executeScriptFromInfoObject() throws EnvInjectException {
        if (this.info.getScriptFilePath() != null) {
            String scriptFilePathResolved = Util.replaceMacro((String)this.info.getScriptFilePath(), this.currentEnvVars);
            String scriptFilePathNormalized = scriptFilePathResolved.replace("\\", "/");
            this.executeScriptPath(scriptFilePathNormalized);
        }
        if (this.info.getScriptContent() != null) {
            String scriptResolved = Util.replaceMacro((String)this.info.getScriptContent(), this.currentEnvVars);
            this.executeScriptContent(scriptResolved);
        }
    }

    private void executeScriptPath(String scriptFilePath) throws EnvInjectException {
        block4: {
            try {
                FilePath f = new FilePath(this.rootScriptExecutionPath, scriptFilePath);
                if (f.exists()) {
                    this.launcher.getListener().getLogger().println(String.format("Executing '%s' script.", scriptFilePath));
                    int cmdCode = this.launcher.launch().cmds(new File(scriptFilePath), new String[0]).stdout(this.launcher.getListener()).pwd(this.rootScriptExecutionPath).join();
                    if (cmdCode != 0) {
                        this.logger.info(String.format("The exit code is '%s'. Fail the build.", cmdCode));
                    }
                    break block4;
                }
                String message = String.format("Can't load the file '%s'. It doesn't exist.", f.getRemote());
                this.logger.error(message);
                throw new EnvInjectException(message);
            }
            catch (Throwable e) {
                throw new EnvInjectException("Error occurs on execution script file path.", e);
            }
        }
    }

    private void executeScriptContent(String scriptContent) throws EnvInjectException {
        try {
            Object batchRunner = this.launcher.isUnix() ? new Shell(scriptContent) : new BatchFile(scriptContent);
            FilePath tmpFile = batchRunner.createScriptFile(this.rootScriptExecutionPath);
            this.logger.info(String.format("Executing the script: \n %s", scriptContent));
            int cmdCode = this.launcher.launch().cmds(batchRunner.buildCommandLine(tmpFile)).stdout(this.launcher.getListener()).pwd(this.rootScriptExecutionPath).join();
            if (cmdCode != 0) {
                String message = String.format("The exit code is '%s'. Fail the build.", cmdCode);
                this.logger.error(message);
                throw new EnvInjectException(message);
            }
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Error occurs on execution script file path", ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException("Error occurs on execution script file path", ie);
        }
    }
}

