/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.Util;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.util.SortedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesService
implements Serializable {
    public Map<String, String> getVarsFromPropertiesFile(File propertiesFile) throws EnvInjectException {
        if (propertiesFile == null) {
            throw new NullPointerException("The properties file object must be set.");
        }
        if (!propertiesFile.exists()) {
            throw new NullPointerException("The properties file object must be exist.");
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        SortedProperties properties = new SortedProperties();
        try {
            String fileContent = Util.loadFile((File)propertiesFile);
            fileContent = this.processWindowsFilePath(fileContent);
            properties.load(new StringReader(fileContent));
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Problem occurs on loading content", ioe);
        }
        for (Map.Entry entry : properties.entrySet()) {
            result.put(this.processProperty(entry.getKey()), this.processProperty(entry.getValue()));
        }
        return result;
    }

    public Map<String, String> getVarsFromPropertiesContent(String fileContent) throws EnvInjectException {
        if (fileContent == null) {
            throw new NullPointerException("The file content object must be set.");
        }
        fileContent = this.processWindowsFilePath(fileContent);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringReader stringReader = new StringReader(fileContent);
        SortedProperties properties = new SortedProperties();
        try {
            properties.load(stringReader);
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Problem occurs on loading content", ioe);
        }
        finally {
            stringReader.close();
        }
        for (Map.Entry entry : properties.entrySet()) {
            result.put(this.processProperty(entry.getKey()), this.processProperty(entry.getValue()));
        }
        return result;
    }

    private String processProperty(Object prop) {
        if (prop == null) {
            return null;
        }
        return String.valueOf(prop).trim();
    }

    private String processWindowsFilePath(String content) {
        if (content == null) {
            return null;
        }
        content = content.replace("\\\\", "\\");
        return content.replace("\\", "\\\\");
    }
}

