/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.File;
import java.io.ObjectStreamException;
import java.util.Map;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.service.EnvInjectSaveable;
import org.jenkinsci.plugins.envinject.EnvInjectVarList;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class EnvInjectAction
implements Action,
StaplerProxy {
    public static String URL_NAME = "injectedEnvVars";
    private transient Map<String, String> envMap;
    private AbstractBuild build;
    private transient Map<String, String> resultVariables;
    private transient File rootDir;

    public EnvInjectAction(AbstractBuild build, Map<String, String> envMap) {
        this.build = build;
        this.envMap = envMap;
    }

    public void overrideAll(Map<String, String> all) {
        this.envMap.putAll(all);
    }

    public Map<String, String> getEnvMap() {
        return UnmodifiableMap.decorate(this.envMap);
    }

    public String getIconFileName() {
        return "document-properties.gif";
    }

    public String getDisplayName() {
        return "Injected Environment Variables";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public Object getTarget() {
        return new EnvInjectVarList(this.envMap);
    }

    private Object writeReplace() throws ObjectStreamException {
        if (this.envMap == null) {
            return this;
        }
        if (this.envMap.size() == 0) {
            return this;
        }
        try {
            EnvInjectSaveable dao = new EnvInjectSaveable();
            if (this.rootDir == null) {
                dao.saveEnvironment(this.build.getRootDir(), this.envMap);
                return this;
            }
            dao.saveEnvironment(this.rootDir, this.envMap);
        }
        catch (EnvInjectException e) {
            e.printStackTrace();
        }
        return this;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.resultVariables != null) {
            this.envMap = this.resultVariables;
            return this;
        }
        EnvInjectSaveable dao = new EnvInjectSaveable();
        Map resultMap = null;
        try {
            if (this.build != null) {
                resultMap = dao.getEnvironment(this.build.getRootDir());
            } else if (this.rootDir != null) {
                resultMap = dao.getEnvironment(this.rootDir);
            }
            if (resultMap != null) {
                this.envMap = resultMap;
            }
        }
        catch (EnvInjectException e) {
            e.printStackTrace();
        }
        return this;
    }
}

