/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.Util;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.service.PropertiesGetter;
import org.jenkinsci.plugins.envinject.service.PropertiesLoader;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectInfo
implements Serializable {
    protected String propertiesFilePath;
    protected String propertiesContent;
    @Deprecated
    private transient Map<String, String> propertiesContentMap;
    @Deprecated
    protected transient boolean populateTriggerCause;

    @DataBoundConstructor
    public EnvInjectInfo(String propertiesFilePath, String propertiesContent) {
        this.propertiesFilePath = Util.fixEmpty((String)propertiesFilePath);
        this.propertiesContent = this.fixCrLf(Util.fixEmpty((String)propertiesContent));
    }

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public String getPropertiesContent() {
        if (this.propertiesContentMap != null && this.propertiesContentMap.size() != 0) {
            PropertiesGetter propertiesGetter = new PropertiesGetter();
            return propertiesGetter.getPropertiesContent(this.propertiesContentMap);
        }
        return this.propertiesContent;
    }

    public Map<String, String> getPropertiesContentMap() {
        if (this.propertiesContentMap != null && this.propertiesContentMap.size() != 0) {
            return this.propertiesContentMap;
        }
        if (this.propertiesContent != null) {
            HashMap<String, String> contentMap = new HashMap();
            PropertiesLoader loader = new PropertiesLoader();
            try {
                contentMap = loader.getVarsFromPropertiesContent(this.propertiesContent);
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
            }
            return contentMap;
        }
        return null;
    }

    protected String fixCrLf(String s) {
        int idx;
        if (s == null) {
            return null;
        }
        while ((idx = s.indexOf("\r\n")) != -1) {
            s = s.substring(0, idx) + s.substring(idx + 1);
        }
        return s;
    }
}

