/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.remoting.Callable;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectPluginAction;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.service.BuildWrapperService;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectPasswordsMasker;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class EnvInjectListener
extends RunListener<Run>
implements Serializable {
    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.isEligibleJobType(build) && !(build instanceof MatrixBuild)) {
            EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
            try {
                Node buildNode = build.getBuiltOn();
                if (buildNode != null) {
                    this.loadEnvironmentVariablesNode(build, buildNode, logger);
                }
                if (this.isEnvInjectJobPropertyActive(build)) {
                    return this.setUpEnvironmentJobPropertyObject(build, launcher, listener, logger);
                }
                return this.setUpEnvironmentWithoutJobPropertyObject(build, launcher, listener);
            }
            catch (Run.RunnerAbortedException rre) {
                logger.info("Fail the build.");
                throw new Run.RunnerAbortedException();
            }
            catch (Throwable throwable) {
                logger.error("SEVERE ERROR occurs: " + throwable.getMessage());
                throw new Run.RunnerAbortedException();
            }
        }
        return new Environment(){};
    }

    private boolean isEligibleJobType(AbstractBuild build) {
        if (build == null) {
            throw new IllegalArgumentException("A build object must be set.");
        }
        Job job = build instanceof MatrixRun ? ((MatrixRun)build).getParentBuild().getParent() : build.getParent();
        return job instanceof FreeStyleProject || job instanceof MatrixProject || job instanceof AbstractMavenProject;
    }

    private void loadEnvironmentVariablesNode(AbstractBuild build, Node buildNode, EnvInjectLogger logger) throws EnvInjectException {
        logger.info("Loading node environment variables.");
        if (buildNode == null) {
            return;
        }
        FilePath nodePath = buildNode.getRootPath();
        if (nodePath == null) {
            return;
        }
        try {
            EnvInjectEnvVars envInjectEnvVars;
            EnvVars envVars;
            EnvironmentVariablesNodeProperty variablesNodeProperty;
            HashMap<String, String> configNodeEnvVars = new HashMap<String, String>();
            Map nodeEnvVars = (Map)nodePath.act((Callable)new Callable<Map<String, String>, IOException>(){

                public Map<String, String> call() throws IOException {
                    return EnvVars.masterEnvVars;
                }
            });
            for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
                if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                variablesNodeProperty = (EnvironmentVariablesNodeProperty)nodeProperty;
                envVars = variablesNodeProperty.getEnvVars();
                envInjectEnvVars = new EnvInjectEnvVars(logger);
                configNodeEnvVars.putAll((Map<String, String>)envVars);
                envInjectEnvVars.resolveVars(configNodeEnvVars, nodeEnvVars);
            }
            for (NodeProperty nodeProperty : buildNode.getNodeProperties()) {
                if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                variablesNodeProperty = (EnvironmentVariablesNodeProperty)nodeProperty;
                envVars = variablesNodeProperty.getEnvVars();
                envInjectEnvVars = new EnvInjectEnvVars(logger);
                configNodeEnvVars.putAll((Map<String, String>)envVars);
                envInjectEnvVars.resolveVars(configNodeEnvVars, nodeEnvVars);
            }
            EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(nodePath);
            envInjectActionSetter.addEnvVarsToEnvInjectBuildAction(build, configNodeEnvVars);
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException((Throwable)ie);
        }
    }

    private boolean isEnvInjectJobPropertyActive(AbstractBuild build) {
        EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
        EnvInjectJobProperty envInjectJobProperty = variableGetter.getEnvInjectJobProperty(build);
        return envInjectJobProperty != null;
    }

    private Environment setUpEnvironmentJobPropertyObject(AbstractBuild build, Launcher launcher, BuildListener listener, EnvInjectLogger logger) throws IOException, InterruptedException, EnvInjectException {
        logger.info("Preparing an environment for the build.");
        EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
        EnvInjectJobProperty envInjectJobProperty = variableGetter.getEnvInjectJobProperty(build);
        assert (envInjectJobProperty != null);
        EnvInjectJobPropertyInfo info = envInjectJobProperty.getInfo();
        assert (envInjectJobProperty != null && envInjectJobProperty.isOn());
        Map<String, String> previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, logger);
        LinkedHashMap<String, String> infraEnvVarsNode = new LinkedHashMap<String, String>(previousEnvVars);
        LinkedHashMap<String, String> infraEnvVarsMaster = new LinkedHashMap<String, String>(previousEnvVars);
        if (envInjectJobProperty.isKeepJenkinsSystemVariables()) {
            logger.info("Keeping Jenkins system variables.");
            infraEnvVarsMaster.putAll(variableGetter.getJenkinsSystemVariables(true));
            infraEnvVarsNode.putAll(variableGetter.getJenkinsSystemVariables(false));
        }
        if (envInjectJobProperty.isKeepBuildVariables()) {
            logger.info("Keeping Jenkins build variables.");
            Map<String, String> buildVariables = variableGetter.getBuildVariables(build, logger);
            infraEnvVarsMaster.putAll(buildVariables);
            infraEnvVarsNode.putAll(buildVariables);
        }
        logger.info("Adding build parameters as variables.");
        Map<String, String> parametersVariables = variableGetter.overrideParametersVariablesWithSecret(build);
        infraEnvVarsNode.putAll(parametersVariables);
        FilePath rootPath = this.getNodeRootPath();
        if (rootPath != null) {
            EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
            int resultCode = envInjectEnvVarsService.executeScript(info.isLoadFilesFromMaster(), info.getScriptContent(), rootPath, info.getScriptFilePath(), infraEnvVarsMaster, infraEnvVarsNode, launcher, listener);
            if (resultCode != 0) {
                build.setResult(Result.FAILURE);
                throw new Run.RunnerAbortedException();
            }
            Map<String, String> groovyMapEnvVars = envInjectEnvVarsService.executeAndGetMapGroovyScript(info.getGroovyScriptContent(), infraEnvVarsNode);
            Map<String, String> propertiesVariables = envInjectEnvVarsService.getEnvVarsPropertiesJobProperty(rootPath, logger, info.isLoadFilesFromMaster(), info.getPropertiesFilePath(), info.getPropertiesContentMap(), infraEnvVarsMaster, infraEnvVarsNode);
            Map<String, String> contributionVariables = this.getEnvVarsByContribution(build, envInjectJobProperty, logger, listener);
            final Map<String, String> resultVariables = envInjectEnvVarsService.getMergedVariables(infraEnvVarsNode, propertiesVariables, groovyMapEnvVars, contributionVariables);
            new EnvInjectActionSetter(rootPath).addEnvVarsToEnvInjectBuildAction(build, resultVariables);
            BuildWrapperService wrapperService = new BuildWrapperService();
            wrapperService.addBuildWrapper(build, new JobSetupEnvironmentWrapper());
            return new Environment(){

                public void buildEnvVars(Map<String, String> env) {
                    env.putAll(resultVariables);
                }
            };
        }
        return new Environment(){};
    }

    private Environment setUpEnvironmentWithoutJobPropertyObject(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, EnvInjectException {
        final HashMap<String, String> resultVariables = new HashMap<String, String>();
        EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        Map<String, String> previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, logger);
        resultVariables.putAll(previousEnvVars);
        resultVariables.putAll(variableGetter.getJenkinsSystemVariables(false));
        resultVariables.putAll(variableGetter.getBuildVariables(build, logger));
        FilePath rootPath = this.getNodeRootPath();
        if (rootPath != null) {
            new EnvInjectActionSetter(rootPath).addEnvVarsToEnvInjectBuildAction(build, resultVariables);
        }
        return new Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.putAll(resultVariables);
            }
        };
    }

    private Node getNode() {
        Computer computer = Computer.currentComputer();
        if (computer == null) {
            return null;
        }
        return computer.getNode();
    }

    private FilePath getNodeRootPath() {
        Node node = this.getNode();
        if (node != null) {
            return node.getRootPath();
        }
        return null;
    }

    private Map<String, String> getEnvVarsByContribution(AbstractBuild build, EnvInjectJobProperty envInjectJobProperty, EnvInjectLogger logger, BuildListener listener) throws EnvInjectException {
        assert (envInjectJobProperty != null);
        HashMap<String, String> contributionVariables = new HashMap<String, String>();
        EnvInjectJobPropertyContributor[] contributors = envInjectJobProperty.getContributors();
        if (contributors != null) {
            logger.info("Injecting contributions.");
            for (EnvInjectJobPropertyContributor contributor : contributors) {
                contributionVariables.putAll(contributor.getEnvVars(build, (TaskListener)listener));
            }
        }
        return contributionVariables;
    }

    public void onCompleted(Run run, TaskListener listener) {
        AbstractBuild build = (AbstractBuild)run;
        if (this.isEligibleJobType(build) && !(build instanceof MatrixBuild)) {
            EnvVars envVars = new EnvVars();
            EnvInjectLogger logger = new EnvInjectLogger(listener);
            EnvInjectPluginAction envInjectAction = (EnvInjectPluginAction)run.getAction(EnvInjectPluginAction.class);
            if (envInjectAction != null) {
                try {
                    BuildWrapperService wrapperService = new BuildWrapperService();
                    wrapperService.removeBuildWrappers(build, JobSetupEnvironmentWrapper.class);
                }
                catch (EnvInjectException e) {
                    logger.error("SEVERE ERROR occurs: " + e.getMessage());
                    throw new Run.RunnerAbortedException();
                }
            }
            AbstractBuild abstractBuild = (AbstractBuild)run;
            try {
                envVars.putAll((Map)abstractBuild.getEnvironment(listener));
            }
            catch (IOException e) {
                logger.error("SEVERE ERROR occurs: " + e.getMessage());
                throw new Run.RunnerAbortedException();
            }
            catch (InterruptedException e) {
                logger.error("SEVERE ERROR occurs: " + e.getMessage());
                throw new Run.RunnerAbortedException();
            }
            EnvInjectPasswordsMasker passwordsMasker = new EnvInjectPasswordsMasker();
            passwordsMasker.maskPasswordsIfAny(build, logger, (Map<String, String>)envVars);
            EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(this.getNodeRootPath());
            try {
                envInjectActionSetter.addEnvVarsToEnvInjectBuildAction((AbstractBuild)run, (Map<String, String>)envVars);
            }
            catch (EnvInjectException e) {
                logger.error("SEVERE ERROR occurs: " + e.getMessage());
                throw new Run.RunnerAbortedException();
            }
            catch (IOException e) {
                logger.error("SEVERE ERROR occurs: " + e.getMessage());
                throw new Run.RunnerAbortedException();
            }
            catch (InterruptedException e) {
                logger.error("SEVERE ERROR occurs: " + e.getMessage());
                throw new Run.RunnerAbortedException();
            }
        }
    }

    public static class JobSetupEnvironmentWrapper
    extends BuildWrapper {
        public void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            EnvInjectLogger envInjectLogger = new EnvInjectLogger((TaskListener)listener);
            EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
            EnvInjectJobProperty envInjectJobProperty = variableGetter.getEnvInjectJobProperty(build);
            assert (envInjectJobProperty != null);
            if (envInjectJobProperty.isKeepBuildVariables()) {
                try {
                    Map<String, String> previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, envInjectLogger);
                    FilePath ws = build.getWorkspace();
                    previousEnvVars.put("WORKSPACE", ws.getRemote());
                    new EnvInjectActionSetter(build.getBuiltOn().getRootPath()).addEnvVarsToEnvInjectBuildAction(build, previousEnvVars);
                }
                catch (EnvInjectException e) {
                    throw new IOException(e);
                }
            }
        }

        public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            return new BuildWrapper.Environment(){};
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class JobSetupEnvironmentWrapperDescriptor
        extends BuildWrapperDescriptor {
            public JobSetupEnvironmentWrapperDescriptor() {
            }

            public JobSetupEnvironmentWrapperDescriptor(Class<? extends BuildWrapper> clazz) {
                super(JobSetupEnvironmentWrapper.class);
            }

            public boolean isApplicable(AbstractProject<?, ?> item) {
                return false;
            }

            public String getDisplayName() {
                return null;
            }
        }
    }
}

