/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.envinject.EnvInjectGlobalPasswordEntry;
import org.jenkinsci.plugins.envinject.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectNodeProperty
extends NodeProperty<Node> {
    private boolean unsetSystemVariables;
    private String propertiesFilePath;

    @DataBoundConstructor
    public EnvInjectNodeProperty(boolean unsetSystemVariables, String propertiesFilePath) {
        this.unsetSystemVariables = unsetSystemVariables;
        this.propertiesFilePath = Util.fixEmpty((String)propertiesFilePath);
    }

    public boolean isUnsetSystemVariables() {
        return this.unsetSystemVariables;
    }

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class EnvInjectNodePropertyDescriptor
    extends NodePropertyDescriptor {
        private static final Logger LOGGER = Logger.getLogger(EnvInjectNodePropertyDescriptor.class.getName());
        private EnvInjectGlobalPasswordEntry[] envInjectGlobalPasswordEntries = new EnvInjectGlobalPasswordEntry[0];
        private static final String ENVINJECT_CONFIG = "envInject.xml";

        public EnvInjectNodePropertyDescriptor() {
            this.load();
        }

        public EnvInjectNodePropertyDescriptor(Class<? extends NodeProperty<?>> clazz) {
            super(clazz);
            this.load();
        }

        public String getDisplayName() {
            return Messages.envinject_nodeProperty_displayName();
        }

        public String getHelpFile() {
            return "/plugin/envinject/help-node.html";
        }

        public EnvInjectGlobalPasswordEntry[] getEnvInjectGlobalPasswordEntries() {
            return this.envInjectGlobalPasswordEntries;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            List envInjectGlobalPasswordEntriesList = req.bindParametersToList(EnvInjectGlobalPasswordEntry.class, "envInject.");
            this.envInjectGlobalPasswordEntries = envInjectGlobalPasswordEntriesList.toArray(new EnvInjectGlobalPasswordEntry[envInjectGlobalPasswordEntriesList.size()]);
            this.save();
            return true;
        }

        public void save() {
            try {
                EnvInjectNodePropertyDescriptor.getConfigFile().write((Object)this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to save global passwords ", e);
            }
        }

        public synchronized void load() {
            XmlFile file = EnvInjectNodePropertyDescriptor.getConfigFile();
            if (!file.exists()) {
                return;
            }
            try {
                file.unmarshal((Object)this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + file, e);
            }
        }

        public static XmlFile getConfigFile() {
            return new XmlFile(new File(Hudson.getInstance().getRootDir(), ENVINJECT_CONFIG));
        }
    }
}

