/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.model.Api;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletOutputStream;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=99)
public class EnvInjectVarList
implements Serializable {
    private Map<String, String> envVars = new TreeMap<String, String>();

    public EnvInjectVarList(Map<String, String> envMap) {
        this.envVars.putAll(envMap);
    }

    @Exported
    public Map<String, String> getEnvMap() {
        return this.envVars;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public void doExport(StaplerRequest request, StaplerResponse response) throws IOException {
        String path = request.getPathInfo();
        if (path != null) {
            this.doExportWithPath(path, request, response);
            return;
        }
        this.doExportHeaders(request, response);
    }

    private void doExportWithPath(String path, StaplerRequest request, StaplerResponse response) throws IOException {
        if (path.endsWith("text")) {
            this.writeTextResponse(response);
            return;
        }
        if (path.endsWith("xml")) {
            this.writeXmlResponse(response);
            return;
        }
        if (path.endsWith("json")) {
            this.writeJsonResponse(response);
            return;
        }
        this.doExportHeaders(request, response);
    }

    private void doExportHeaders(StaplerRequest request, StaplerResponse response) throws IOException {
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader == null) {
            this.writeTextResponse(response);
            return;
        }
        if (acceptHeader.contains("application/xml")) {
            this.writeXmlResponse(response);
            return;
        }
        if (acceptHeader.contains("application/json")) {
            this.writeJsonResponse(response);
            return;
        }
        this.writeTextResponse(response);
    }

    private void writeTextResponse(StaplerResponse response) throws IOException {
        response.setContentType("plain/text");
        StringWriter stringWriter = new StringWriter();
        for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
            stringWriter.write(String.format("%s%s%s\n", entry.getKey(), "=", entry.getValue()));
        }
        response.getOutputStream().write(stringWriter.toString().getBytes());
    }

    private void writeXmlResponse(StaplerResponse response) throws IOException {
        response.setContentType("application/xml");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write("<envVars>".getBytes());
        for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
            outputStream.write(String.format("<envVar name=\"%s\" value=\"%s\"/>", entry.getKey(), entry.getValue()).getBytes());
        }
        outputStream.write("</envVars>".getBytes());
    }

    private void writeJsonResponse(StaplerResponse response) throws IOException {
        response.setContentType("application/json");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write("{\"envVars\": { \"envVar\":[".getBytes());
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
            sb.append(String.format(", {\"name\":\"%s\", \"value\":\"%s\"}", entry.getKey(), entry.getValue()));
        }
        sb.delete(0, 1);
        outputStream.write(sb.toString().getBytes());
        outputStream.write("]}}".getBytes());
    }
}

