/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.migration;

import hudson.Extension;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.plugins.envfile.EnvFileBuildWrapper;
import hudson.plugins.setenv.SetEnvBuildWrapper;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordEntry;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordWrapper;
import org.jenkinsci.plugins.envinject.migration.EnvInjectMigrationBuildWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class EnvInjectMigrationListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(EnvInjectMigrationListener.class.getName());

    private boolean containAPluginToMigrate(Class<? extends BuildWrapper> wrapperClass) {
        return EnvFileBuildWrapper.class.isAssignableFrom(wrapperClass) || SetEnvBuildWrapper.class.isAssignableFrom(wrapperClass);
    }

    public void onLoaded() {
        List items = Hudson.getInstance().getItems();
        for (TopLevelItem item : items) {
            try {
                if (item instanceof Job) {
                    Job job = (Job)item;
                    Map propertyMap = job.getProperties();
                    for (JobProperty jobProperty : propertyMap.values()) {
                        EnvInjectJobProperty envInjectJobProperty;
                        if (jobProperty.getClass() != EnvInjectJobProperty.class || !(envInjectJobProperty = (EnvInjectJobProperty)jobProperty).isOn()) continue;
                        EnvInjectPasswordWrapper passwordWrapper = new EnvInjectPasswordWrapper();
                        boolean isInjectGlobalPasswords = envInjectJobProperty.isInjectGlobalPasswords();
                        EnvInjectPasswordEntry[] passwordEntries = envInjectJobProperty.getPasswordEntries();
                        if (!isInjectGlobalPasswords && (passwordEntries == null || passwordEntries.length == 0)) continue;
                        passwordWrapper.setInjectGlobalPasswords(isInjectGlobalPasswords);
                        passwordWrapper.setPasswordEntries(passwordEntries);
                        if (!(item instanceof BuildableItemWithBuildWrappers)) continue;
                        BuildableItemWithBuildWrappers buildableItemWithBuildWrappers = (BuildableItemWithBuildWrappers)item;
                        this.addOrModifyEnvInjectBuildWrapper((DescribableList<BuildWrapper, Descriptor<BuildWrapper>>)buildableItemWithBuildWrappers.getBuildWrappersList(), passwordWrapper);
                        buildableItemWithBuildWrappers.save();
                    }
                }
                if (!(item instanceof BuildableItemWithBuildWrappers)) continue;
                BuildableItemWithBuildWrappers buildableItemWithBuildWrappers = (BuildableItemWithBuildWrappers)item;
                DescribableList wrappersList = buildableItemWithBuildWrappers.getBuildWrappersList();
                Iterator buildWrapperIterator = wrappersList.iterator();
                while (buildWrapperIterator.hasNext()) {
                    BuildWrapper buildWrapper = (BuildWrapper)buildWrapperIterator.next();
                    if (!this.containAPluginToMigrate(buildWrapper.getClass())) continue;
                    EnvInjectMigrationBuildWrapper oldWrapper = (EnvInjectMigrationBuildWrapper)buildWrapper;
                    buildWrapperIterator.remove();
                    this.addOrModifyEnvInjectBuildWrapper((DescribableList<BuildWrapper, Descriptor<BuildWrapper>>)buildableItemWithBuildWrappers.getBuildWrappersList(), oldWrapper.getEnvInjectBuildWrapper());
                    buildableItemWithBuildWrappers.save();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't migrate old plugins to EnvInject plugin for the item %s", item.getName());
                e.printStackTrace();
            }
            catch (EnvInjectException e) {
                LOGGER.log(Level.SEVERE, "Can't migrate old plugins to EnvInject plugin for the item %s", item.getName());
                e.printStackTrace();
            }
        }
    }

    private void addOrModifyEnvInjectBuildWrapper(DescribableList<BuildWrapper, Descriptor<BuildWrapper>> wrappers, BuildWrapper wrapper) throws EnvInjectException {
        Iterator buildWrapperIterator = wrappers.iterator();
        while (buildWrapperIterator.hasNext()) {
            BuildWrapper buildWrapper = (BuildWrapper)buildWrapperIterator.next();
            if (!buildWrapper.getClass().isAssignableFrom(wrapper.getClass())) continue;
            buildWrapperIterator.remove();
        }
        try {
            wrappers.add((Object)wrapper);
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
    }
}

