/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import groovy.lang.GroovyShell;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.service.EnvInjectScriptExecutor;
import org.jenkinsci.plugins.envinject.service.PropertiesVariablesRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectEnvVars
implements Serializable {
    EnvInjectLogger logger;

    public EnvInjectEnvVars(EnvInjectLogger logger) {
        this.logger = logger;
    }

    public Map<String, String> getEnvVarsPropertiesJobProperty(FilePath rootPath, EnvInjectLogger logger, boolean loadFilesFromMaster, String propertiesFilePath, Map<String, String> propertiesContent, Map<String, String> infraEnvVarsMaster, Map<String, String> infraEnvVarsNode) throws EnvInjectException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        try {
            if (loadFilesFromMaster) {
                resultMap.putAll((Map)Hudson.getInstance().getRootPath().act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, infraEnvVarsMaster, logger)));
            } else {
                resultMap.putAll((Map)rootPath.act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, infraEnvVarsNode, logger)));
            }
        }
        catch (IOException e) {
            throw new EnvInjectException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new EnvInjectException((Throwable)e);
        }
        return resultMap;
    }

    public Map<String, String> getEnvVarsPropertiesProperty(FilePath rootPath, EnvInjectLogger logger, String propertiesFilePath, Map<String, String> propertiesContent, Map<String, String> currentEnvVars) throws EnvInjectException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        try {
            resultMap.putAll((Map)rootPath.act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, currentEnvVars, logger)));
        }
        catch (IOException e) {
            throw new EnvInjectException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new EnvInjectException((Throwable)e);
        }
        return resultMap;
    }

    public int executeScript(boolean loadFromMaster, String scriptContent, FilePath scriptExecutionRoot, String scriptFilePath, Map<String, String> infraEnvVarsMaster, Map<String, String> infraEnvVarsNode, Launcher launcher, BuildListener listener) throws EnvInjectException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        EnvInjectScriptExecutor scriptExecutor = new EnvInjectScriptExecutor(launcher, logger);
        HashMap<String, String> scriptExecutionEnvVars = new HashMap<String, String>();
        scriptExecutionEnvVars.putAll(infraEnvVarsNode);
        if (loadFromMaster) {
            HashMap<String, String> scriptPathExecutionEnvVars = new HashMap<String, String>();
            scriptPathExecutionEnvVars.putAll(infraEnvVarsMaster);
            return scriptExecutor.executeScriptSection(scriptExecutionRoot, scriptFilePath, scriptContent, scriptPathExecutionEnvVars, scriptExecutionEnvVars);
        }
        return scriptExecutor.executeScriptSection(scriptExecutionRoot, scriptFilePath, scriptContent, scriptExecutionEnvVars, scriptExecutionEnvVars);
    }

    public Map<String, String> executeAndGetMapGroovyScript(String scriptContent, Map<String, String> envVars) throws EnvInjectException {
        if (scriptContent == null) {
            return new HashMap<String, String>();
        }
        if (scriptContent.trim().length() == 0) {
            return new HashMap<String, String>();
        }
        this.logger.info(String.format("Evaluation the following Groovy script content: \n%s\n", scriptContent));
        GroovyShell shell = new GroovyShell();
        for (Map.Entry<String, String> entryVariable : envVars.entrySet()) {
            shell.setVariable(entryVariable.getKey(), (Object)entryVariable.getValue());
        }
        Object groovyResult = shell.evaluate(scriptContent);
        if (groovyResult != null && !(groovyResult instanceof Map)) {
            throw new EnvInjectException("The evaluated Groovy script must return a Map object.");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (groovyResult == null) {
            return result;
        }
        for (Map.Entry entry : ((Map)groovyResult).entrySet()) {
            result.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return result;
    }

    public int executeScript(String scriptContent, FilePath scriptExecutionRoot, String scriptFilePath, Map<String, String> envVars, Launcher launcher, BuildListener listener) throws EnvInjectException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        EnvInjectScriptExecutor scriptExecutor = new EnvInjectScriptExecutor(launcher, logger);
        return scriptExecutor.executeScriptSection(scriptExecutionRoot, scriptFilePath, scriptContent, envVars, envVars);
    }

    public Map<String, String> getMergedVariables(Map<String, String> infraEnvVars, Map<String, String> propertiesEnvVars) {
        return this.getMergedVariables(infraEnvVars, propertiesEnvVars, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public Map<String, String> getMergedVariables(Map<String, String> infraEnvVars, Map<String, String> propertiesEnvVars, Map<String, String> groovyMapEnvVars, Map<String, String> contribEnvVars) {
        this.resolveVars(propertiesEnvVars, infraEnvVars);
        this.resolveVars(propertiesEnvVars, groovyMapEnvVars);
        this.resolveVars(propertiesEnvVars, contribEnvVars);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>(infraEnvVars);
        variables.putAll(groovyMapEnvVars);
        variables.putAll(contribEnvVars);
        variables.putAll(propertiesEnvVars);
        return this.removeUnsetVars(variables);
    }

    public void resolveVars(Map<String, String> variables, Map<String, String> env) {
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String value = Util.replaceMacro((String)entry.getValue(), env);
            entry.setValue(value);
        }
        boolean stopToResolveVars = false;
        int nbUnresolvedVar = 0;
        while (!stopToResolveVars) {
            int previousNbUnresolvedVar = nbUnresolvedVar;
            nbUnresolvedVar = 0;
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String value = Util.replaceMacro((String)entry.getValue(), variables);
                entry.setValue(value);
                if (!this.isUnresolvedVar(value)) continue;
                ++nbUnresolvedVar;
            }
            if (previousNbUnresolvedVar != nbUnresolvedVar) continue;
            stopToResolveVars = true;
        }
    }

    private Map<String, String> removeUnsetVars(Map<String, String> envVars) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            if (!this.isUnresolvedVar(entry.getValue())) {
                result.put(entry.getKey(), this.removeEscapeDollar(entry.getValue()));
                continue;
            }
            this.logger.info(String.format("Unset unresolved '%s' variable.", entry.getKey()));
        }
        return result;
    }

    private boolean isUnresolvedVar(String value) {
        return value != null && value.contains("$") && !value.contains("\\$");
    }

    private String removeEscapeDollar(String value) {
        if ('/' == File.separatorChar) {
            return value.replace("\\$", "$");
        }
        return value;
    }
}

