/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectScriptExecutor {
    private Launcher launcher;
    private EnvInjectLogger logger;

    public EnvInjectScriptExecutor(Launcher launcher, EnvInjectLogger logger) {
        this.launcher = launcher;
        this.logger = logger;
    }

    public int executeScriptSection(FilePath scriptExecutionRoot, String scriptFilePath, String scriptContent, Map<String, String> scriptPathExecutionEnvVars, Map<String, String> scriptExecutionEnvVars) throws EnvInjectException {
        int resultCode;
        String scriptFilePathResolved;
        String scriptFilePathNormalized;
        int resultCode2;
        if (scriptFilePath != null && (resultCode2 = this.executeScriptPath(scriptExecutionRoot, scriptFilePathNormalized = (scriptFilePathResolved = Util.replaceMacro((String)scriptFilePath, scriptPathExecutionEnvVars)).replace("\\", "/"), scriptExecutionEnvVars)) != 0) {
            return resultCode2;
        }
        if (scriptContent != null && (resultCode = this.executeScriptContent(scriptExecutionRoot, scriptContent, scriptExecutionEnvVars)) != 0) {
            return resultCode;
        }
        return 0;
    }

    private int executeScriptPath(FilePath scriptExecutionRoot, String scriptFilePath, Map<String, String> scriptExecutionEnvVars) throws EnvInjectException {
        try {
            this.launcher.getListener().getLogger().println(String.format("Executing '%s'.", scriptFilePath));
            ArgumentListBuilder cmds = new ArgumentListBuilder();
            cmds.addTokenized(scriptFilePath);
            int cmdCode = this.launcher.launch().cmds(cmds).stdout(this.launcher.getListener()).envs(scriptExecutionEnvVars).pwd(scriptExecutionRoot).join();
            if (cmdCode != 0) {
                this.logger.info(String.format("Script executed. The exit code is %s.", cmdCode));
            } else {
                this.logger.info("Script executed successfully.");
            }
            return cmdCode;
        }
        catch (Throwable e) {
            throw new EnvInjectException("Error occurs on execution script file path.", e);
        }
    }

    private int executeScriptContent(FilePath scriptExecutionRoot, String scriptContent, Map<String, String> scriptExecutionEnvVars) throws EnvInjectException {
        try {
            Object batchRunner = this.launcher.isUnix() ? new Shell(scriptContent) : new BatchFile(scriptContent);
            FilePath tmpFile = batchRunner.createScriptFile(scriptExecutionRoot);
            this.logger.info(String.format("Executing and processing the following script content: \n%s\n", scriptContent));
            int cmdCode = this.launcher.launch().cmds(batchRunner.buildCommandLine(tmpFile)).stdout(this.launcher.getListener()).envs(scriptExecutionEnvVars).pwd(scriptExecutionRoot).join();
            if (cmdCode != 0) {
                this.logger.info(String.format("Script executed. The exit code is %s.", cmdCode));
            } else {
                this.logger.info("Script executed successfully.");
            }
            return cmdCode;
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Error occurs on execution script file path", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException("Error occurs on execution script file path", (Throwable)ie);
        }
    }
}

