/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt;

import com.google.common.base.Strings;
import hudson.model.Cause;
import java.util.Map;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public class GenericCause
extends Cause {
    private final Map<String, String> resolvedVariables;
    private final String postContent;
    private final boolean printContributedVariables;
    private final boolean printPostContent;
    private boolean postContentPrinted;
    private final String cause;

    public GenericCause(String postContent, Map<String, String> resolvedVariables, boolean printContributedVariables, boolean printPostContent, String cause) {
        this.postContent = postContent;
        this.resolvedVariables = resolvedVariables;
        this.printContributedVariables = printContributedVariables;
        this.printPostContent = printPostContent;
        this.postContentPrinted = false;
        this.cause = !Strings.isNullOrEmpty((String)cause) ? cause : "Generic Cause";
    }

    public boolean isPrintContributedVariables() {
        return this.printContributedVariables;
    }

    public boolean isPrintPostContent() {
        return this.printPostContent;
    }

    public void setPostContentPrinted(boolean postContentPrinted) {
        this.postContentPrinted = postContentPrinted;
    }

    public boolean isPostContentPrinted() {
        return this.postContentPrinted;
    }

    public Map<String, String> getResolvedVariables() {
        return this.resolvedVariables;
    }

    public String getPostContent() {
        return this.postContent;
    }

    public String getShortDescription() {
        PolicyFactory policy = Sanitizers.FORMATTING.and(Sanitizers.LINKS);
        return policy.sanitize(this.cause);
    }
}

