/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.InitCommand;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.PushCommand;
import org.jenkinsci.plugins.gitclient.RebaseCommand;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.jenkinsci.plugins.gitclient.RevListCommand;
import org.jenkinsci.plugins.gitclient.SubmoduleUpdateCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface GitClient {
    public static final boolean verbose = Boolean.getBoolean(IGitAPI.class.getName() + ".verbose");
    public static final boolean quietRemoteBranches = Boolean.getBoolean(GitClient.class.getName() + ".quietRemoteBranches");
    public static final CredentialsMatcher CREDENTIALS_MATCHER = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)});

    public void clearCredentials();

    public void addCredentials(String var1, StandardCredentials var2);

    public void addDefaultCredentials(StandardCredentials var1);

    public void setAuthor(String var1, String var2) throws GitException;

    public void setAuthor(PersonIdent var1) throws GitException;

    public void setCommitter(String var1, String var2) throws GitException;

    public void setCommitter(PersonIdent var1) throws GitException;

    public Repository getRepository() throws GitException;

    public <T> T withRepository(RepositoryCallback<T> var1) throws IOException, InterruptedException;

    public FilePath getWorkTree();

    public void init() throws GitException, InterruptedException;

    public void add(String var1) throws GitException, InterruptedException;

    public void commit(String var1) throws GitException, InterruptedException;

    public void commit(String var1, PersonIdent var2, PersonIdent var3) throws GitException, InterruptedException;

    public boolean hasGitRepo() throws GitException, InterruptedException;

    public boolean isCommitInRepo(ObjectId var1) throws GitException, InterruptedException;

    public String getRemoteUrl(String var1) throws GitException, InterruptedException;

    public void setRemoteUrl(String var1, String var2) throws GitException, InterruptedException;

    public void addRemoteUrl(String var1, String var2) throws GitException, InterruptedException;

    public void checkout(String var1) throws GitException, InterruptedException;

    public void checkout(String var1, String var2) throws GitException, InterruptedException;

    public CheckoutCommand checkout();

    public void checkoutBranch(@CheckForNull String var1, String var2) throws GitException, InterruptedException;

    public void clone(String var1, String var2, boolean var3, String var4) throws GitException, InterruptedException;

    public CloneCommand clone_();

    public void fetch(URIish var1, List<RefSpec> var2) throws GitException, InterruptedException;

    public void fetch(String var1, RefSpec ... var2) throws GitException, InterruptedException;

    public void fetch(String var1, RefSpec var2) throws GitException, InterruptedException;

    public FetchCommand fetch_();

    public void push(String var1, String var2) throws GitException, InterruptedException;

    public void push(URIish var1, String var2) throws GitException, InterruptedException;

    public PushCommand push();

    public void merge(ObjectId var1) throws GitException, InterruptedException;

    public MergeCommand merge();

    public RebaseCommand rebase();

    public InitCommand init_();

    public void prune(RemoteConfig var1) throws GitException, InterruptedException;

    public void clean() throws GitException, InterruptedException;

    public void branch(String var1) throws GitException, InterruptedException;

    public void deleteBranch(String var1) throws GitException, InterruptedException;

    public Set<Branch> getBranches() throws GitException, InterruptedException;

    public Set<Branch> getRemoteBranches() throws GitException, InterruptedException;

    public void tag(String var1, String var2) throws GitException, InterruptedException;

    public boolean tagExists(String var1) throws GitException, InterruptedException;

    public String getTagMessage(String var1) throws GitException, InterruptedException;

    public void deleteTag(String var1) throws GitException, InterruptedException;

    public Set<String> getTagNames(String var1) throws GitException, InterruptedException;

    public Set<String> getRemoteTagNames(String var1) throws GitException, InterruptedException;

    public void ref(String var1) throws GitException, InterruptedException;

    public boolean refExists(String var1) throws GitException, InterruptedException;

    public void deleteRef(String var1) throws GitException, InterruptedException;

    public Set<String> getRefNames(String var1) throws GitException, InterruptedException;

    public Map<String, ObjectId> getHeadRev(String var1) throws GitException, InterruptedException;

    public ObjectId getHeadRev(String var1, String var2) throws GitException, InterruptedException;

    public Map<String, ObjectId> getRemoteReferences(String var1, String var2, boolean var3, boolean var4) throws GitException, InterruptedException;

    public ObjectId revParse(String var1) throws GitException, InterruptedException;

    public RevListCommand revList_();

    public List<ObjectId> revListAll() throws GitException, InterruptedException;

    public List<ObjectId> revList(String var1) throws GitException, InterruptedException;

    public GitClient subGit(String var1);

    public boolean hasGitModules() throws GitException, InterruptedException;

    public List<IndexEntry> getSubmodules(String var1) throws GitException, InterruptedException;

    public void addSubmodule(String var1, String var2) throws GitException, InterruptedException;

    public void submoduleUpdate(boolean var1) throws GitException, InterruptedException;

    public void submoduleUpdate(boolean var1, String var2) throws GitException, InterruptedException;

    public void submoduleUpdate(boolean var1, boolean var2) throws GitException, InterruptedException;

    public void submoduleUpdate(boolean var1, boolean var2, String var3) throws GitException, InterruptedException;

    public SubmoduleUpdateCommand submoduleUpdate();

    public void submoduleClean(boolean var1) throws GitException, InterruptedException;

    public void submoduleInit() throws GitException, InterruptedException;

    public void setupSubmoduleUrls(Revision var1, TaskListener var2) throws GitException, InterruptedException;

    public void changelog(String var1, String var2, OutputStream var3) throws GitException, InterruptedException;

    public void changelog(String var1, String var2, Writer var3) throws GitException, InterruptedException;

    public ChangelogCommand changelog();

    public void appendNote(String var1, String var2) throws GitException, InterruptedException;

    public void addNote(String var1, String var2) throws GitException, InterruptedException;

    public List<String> showRevision(ObjectId var1) throws GitException, InterruptedException;

    public List<String> showRevision(ObjectId var1, ObjectId var2) throws GitException, InterruptedException;

    public List<String> showRevision(ObjectId var1, ObjectId var2, Boolean var3) throws GitException, InterruptedException;

    public String describe(String var1) throws GitException, InterruptedException;

    public void setCredentials(StandardUsernameCredentials var1);

    public void setProxy(ProxyConfiguration var1);

    public List<Branch> getBranchesContaining(String var1, boolean var2) throws GitException, InterruptedException;
}

