/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.git.GitException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;

class Netrc {
    private static final Pattern NETRC_TOKEN = Pattern.compile("(\\S+)");
    private File netrc;
    private long lastModified;
    private Map<String, UsernamePasswordCredentials> hosts = new HashMap<String, UsernamePasswordCredentials>();

    public static Netrc getInstance() {
        File netrc = Netrc.getDefaultFile();
        return Netrc.getInstance(netrc);
    }

    public static Netrc getInstance(@NonNull String netrcPath) {
        File netrc = new File(netrcPath);
        return netrc.exists() ? Netrc.getInstance(new File(netrcPath)) : null;
    }

    public static Netrc getInstance(File netrc) {
        return new Netrc(netrc).parse();
    }

    private static File getDefaultFile() {
        File home = new File(System.getProperty("user.home"));
        File netrc = new File(home, ".netrc");
        if (!netrc.exists()) {
            netrc = new File(home, "_netrc");
        }
        return netrc;
    }

    public synchronized Credentials getCredentials(String host) {
        if (!this.netrc.exists()) {
            return null;
        }
        if (this.lastModified != this.netrc.lastModified()) {
            this.parse();
        }
        return (Credentials)this.hosts.get(host);
    }

    private Netrc(File netrc) {
        this.netrc = netrc;
    }

    private synchronized Netrc parse() {
        if (!this.netrc.exists()) {
            return this;
        }
        this.hosts.clear();
        this.lastModified = this.netrc.lastModified();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(Files.newInputStream(this.netrc.toPath(), new OpenOption[0]), Charset.defaultCharset()));){
            String line = null;
            String machine = null;
            String login = null;
            String password = null;
            ParseState state = ParseState.START;
            Matcher matcher = NETRC_TOKEN.matcher("");
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) {
                    if (state != ParseState.MACDEF) continue;
                    state = ParseState.REQ_KEY;
                    continue;
                }
                matcher.reset(line);
                while (matcher.find()) {
                    String match = matcher.group();
                    switch (state) {
                        case START: {
                            if (!"machine".equals(match)) break;
                            state = ParseState.MACHINE;
                            break;
                        }
                        case REQ_KEY: {
                            if ("login".equals(match)) {
                                state = ParseState.LOGIN;
                                break;
                            }
                            if ("password".equals(match)) {
                                state = ParseState.PASSWORD;
                                break;
                            }
                            if ("macdef".equals(match)) {
                                state = ParseState.MACDEF;
                                break;
                            }
                            if ("machine".equals(match)) {
                                state = ParseState.MACHINE;
                                break;
                            }
                            state = ParseState.REQ_VALUE;
                            break;
                        }
                        case REQ_VALUE: {
                            state = ParseState.REQ_KEY;
                            break;
                        }
                        case MACHINE: {
                            if (machine != null && login != null && password != null) {
                                this.hosts.put(machine, new UsernamePasswordCredentials(login, password));
                            }
                            machine = match;
                            login = null;
                            password = null;
                            state = ParseState.REQ_KEY;
                            break;
                        }
                        case LOGIN: {
                            login = match;
                            state = ParseState.REQ_KEY;
                            break;
                        }
                        case PASSWORD: {
                            password = match;
                            state = ParseState.REQ_KEY;
                            break;
                        }
                    }
                }
            }
            if (machine != null && login != null && password != null) {
                this.hosts.put(machine, new UsernamePasswordCredentials(login, password));
            }
        }
        catch (IOException e) {
            throw new GitException("Invalid netrc file: '" + this.netrc.getAbsolutePath() + "'", e);
        }
        return this;
    }

    private static enum ParseState {
        START,
        REQ_KEY,
        REQ_VALUE,
        MACHINE,
        LOGIN,
        PASSWORD,
        MACDEF,
        END;

    }
}

