/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.Messages;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AncestryBuildChooser
extends DefaultBuildChooser {
    private final Integer maximumAgeInDays;
    private final String ancestorCommitSha1;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public AncestryBuildChooser(Integer maximumAgeInDays, String ancestorCommitSha1) {
        this.maximumAgeInDays = maximumAgeInDays;
        this.ancestorCommitSha1 = ancestorCommitSha1;
    }

    public Integer getMaximumAgeInDays() {
        return this.maximumAgeInDays;
    }

    public String getAncestorCommitSha1() {
        return this.ancestorCommitSha1;
    }

    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String branchSpec, GitClient git, TaskListener listener, BuildData data, BuildChooserContext context) throws GitException, IOException, InterruptedException {
        final Collection<Revision> candidates = super.getCandidateRevisions(isPollCall, branchSpec, git, listener, data, context);
        return (Collection)git.withRepository((RepositoryCallback)new RepositoryCallback<List<Revision>>(){

            public List<Revision> invoke(Repository repository, VirtualChannel channel) throws IOException {
                RevWalk walk = new RevWalk(repository);
                RevCommit ancestor = null;
                if (!Strings.isNullOrEmpty((String)AncestryBuildChooser.this.ancestorCommitSha1)) {
                    try {
                        ancestor = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)AncestryBuildChooser.this.ancestorCommitSha1));
                    }
                    catch (IllegalArgumentException e) {
                        throw new GitException((Throwable)e);
                    }
                }
                CommitAgeFilter ageFilter = new CommitAgeFilter(AncestryBuildChooser.this.maximumAgeInDays);
                AncestryFilter ancestryFilter = new AncestryFilter(walk, ancestor);
                ArrayList filteredCandidates = Lists.newArrayList();
                try {
                    for (Revision currentRevision : candidates) {
                        RevCommit currentRev = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)currentRevision.getSha1String()));
                        if (ageFilter.isEnabled() && !ageFilter.apply(currentRev) || ancestryFilter.isEnabled() && !ancestryFilter.apply(currentRev)) continue;
                        filteredCandidates.add(currentRevision);
                    }
                }
                catch (Throwable e) {
                    Iterator ioeIter = Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), IOException.class).iterator();
                    if (ioeIter.hasNext()) {
                        throw (IOException)ioeIter.next();
                    }
                    throw Throwables.propagate((Throwable)e);
                }
                return filteredCandidates;
            }
        });
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return Messages.BuildChooser_Ancestry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AncestryFilter
    implements Predicate<RevCommit> {
        RevWalk revwalk;
        RevCommit ancestor;

        public AncestryFilter(RevWalk revwalk, RevCommit ancestor) {
            this.revwalk = revwalk;
            this.ancestor = ancestor;
        }

        public boolean apply(RevCommit rev) {
            try {
                return this.revwalk.isMergedInto(this.ancestor, rev);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public boolean isEnabled() {
            return this.revwalk != null && this.ancestor != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommitAgeFilter
    implements Predicate<RevCommit> {
        private DateTime oldestAllowableCommitDate = null;

        public CommitAgeFilter(Integer oldestAllowableAgeInDays) {
            if (oldestAllowableAgeInDays != null && oldestAllowableAgeInDays >= 0) {
                this.oldestAllowableCommitDate = new LocalDate().toDateTimeAtStartOfDay().minusDays(oldestAllowableAgeInDays.intValue());
            }
        }

        public boolean apply(RevCommit rev) {
            return new DateTime((Object)rev.getCommitterIdent().getWhen()).isAfter((ReadableInstant)this.oldestAllowableCommitDate);
        }

        public boolean isEnabled() {
            return this.oldestAllowableCommitDate != null;
        }
    }
}

