/*
 * The MIT License
 *
 * Copyright (c) 2018 CloudBees, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.SCMHead;

public class GitRefSCMHead extends SCMHead implements GitSCMHeadMixin {
    private final String ref;

    /**
     * Constructor.
     *
     * @param name the name of the ref.
     * @param ref the ref.
     */
    public GitRefSCMHead(@NonNull String name, @NonNull String ref) {
        super(name);
        this.ref = ref;
    }

    /**
     * Constructor where ref and name are the same.
     *
     * @param name the name (and the ref).
     */
    public GitRefSCMHead(@NonNull String name) {
        this(name, name);
    }

    @Override
    public String getRef() {
        return ref;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("GitRefSCMHead{");
        sb.append("name='").append(getName()).append("'");
        sb.append(", ref='").append(ref).append("'}");
        return sb.toString();
    }
}
