/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class RhodeCode
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public RhodeCode(String repoUrl) {
        super(repoUrl);
    }

    private QueryBuilder param(URL url) {
        return new QueryBuilder(url.getQuery());
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "changeset/" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "diff/" + path.getPath() + this.param(url).add("diff2=" + changeSet.getParentCommit()).add("diff1=" + changeSet.getId()).toString() + "&diff=diff+to+revision");
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            String parentCommit = changeSet.getParentCommit();
            if (parentCommit == null) {
                parentCommit = ".";
            }
            return new URL(url, url.getPath() + "files/" + parentCommit + '/' + path.getPath());
        }
        return new URL(url, url.getPath() + "files/" + changeSet.getId() + '/' + path.getPath());
    }

    @Extension
    public static class RhodeCodeDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @Nonnull
        public String getDisplayName() {
            return "rhodecode";
        }

        public RhodeCode newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (RhodeCode)((Object)req.bindJSON(RhodeCode.class, jsonObject));
        }
    }
}

