/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitBrowserSCMSourceTrait
extends SCMSourceTrait {
    @CheckForNull
    private final GitRepositoryBrowser browser;

    @DataBoundConstructor
    public GitBrowserSCMSourceTrait(@CheckForNull GitRepositoryBrowser browser) {
        this.browser = browser;
    }

    @CheckForNull
    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        ((GitSCMBuilder)builder).withBrowser(this.browser);
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return "Configure Repository Browser";
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Tests use null instance, Jenkins 2.60 declares instance is not null")
        @Restricted(value={NoExternalUse.class})
        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return ((GitSCM.DescriptorImpl)Jenkins.getActiveInstance().getDescriptor(GitSCM.class)).getBrowserDescriptors();
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitSCMSourceContext.class;
        }

        public Class<? extends SCM> getScmClass() {
            return GitSCM.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitSCMSource.class;
        }
    }
}

