/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Action;
import hudson.model.ModelObject;
import hudson.model.Run;
import java.util.Collections;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSampleRepoRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class CredentialsUserRemoteConfigTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    private CredentialsStore store = null;

    @Before
    public void enableSystemCredentialsProvider() {
        SystemCredentialsProvider.getInstance().setDomainCredentialsMap(Collections.singletonMap(Domain.global(), Collections.emptyList()));
        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)Jenkins.get())) {
            if (!(s.getProvider() instanceof SystemCredentialsProvider.ProviderImpl)) continue;
            this.store = s;
            break;
        }
        Assert.assertThat((String)"The system credentials provider is enabled", (Object)this.store, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void checkoutWithValidCredentials() throws Exception {
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        this.store.save();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM', \n      userRemoteConfigs: [[credentialsId: 'github', url: $/" + (Object)((Object)this.sampleRepo) + "/$]]]\n  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("using credential github", (Run)b);
    }

    @Test
    public void checkoutWithDifferentCredentials() throws Exception {
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "other"));
        this.store.save();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM', \n      userRemoteConfigs: [[credentialsId: 'github', url: $/" + (Object)((Object)this.sampleRepo) + "/$]]]\n  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("Warning: CredentialId \"github\" could not be found", (Run)b);
    }

    @Test
    public void checkoutWithInvalidCredentials() throws Exception {
        this.sampleRepo.init();
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.SYSTEM, "github"));
        this.store.save();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM', \n      userRemoteConfigs: [[credentialsId: 'github', url: $/" + (Object)((Object)this.sampleRepo) + "/$]]]\n  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("Warning: CredentialId \"github\" could not be found", (Run)b);
    }

    @Test
    public void checkoutWithNoCredentialsStoredButUsed() throws Exception {
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM', \n      userRemoteConfigs: [[credentialsId: 'github', url: $/" + (Object)((Object)this.sampleRepo) + "/$]]]\n  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("Warning: CredentialId \"github\" could not be found", (Run)b);
    }

    @Test
    public void checkoutWithNoCredentialsSpecified() throws Exception {
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM', \n      userRemoteConfigs: [[url: $/" + (Object)((Object)this.sampleRepo) + "/$]]]\n  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("No credentials specified", (Run)b);
    }

    private StandardCredentials createCredential(CredentialsScope scope, String id) {
        return new UsernamePasswordCredentialsImpl(scope, id, "desc: " + id, "username", "password");
    }
}

