/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetList;
import hudson.scm.RepositoryBrowser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GitChangeSetListTest {
    private final GitChangeSetList emptyChangeSetList;
    private GitChangeSetList changeSetList;
    private GitChangeSet changeSet;

    public GitChangeSetListTest() {
        RepositoryBrowser browser = null;
        Run build = null;
        this.emptyChangeSetList = new GitChangeSetList(build, browser, new ArrayList());
    }

    @Before
    public void createGitChangeSetList() {
        RepositoryBrowser browser = null;
        Run build = null;
        ArrayList<GitChangeSet> logs = new ArrayList<GitChangeSet>();
        ArrayList changeSetText = new ArrayList();
        this.changeSet = new GitChangeSet(changeSetText, true);
        Assert.assertTrue((boolean)logs.add(this.changeSet));
        Assert.assertThat((Object)this.changeSet.getParent(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.changeSetList = new GitChangeSetList(build, browser, logs);
        Assert.assertThat((Object)this.changeSet.getParent(), (Matcher)Matchers.is((Object)this.changeSetList));
    }

    @Test
    public void testIsEmptySet() {
        Assert.assertFalse((boolean)this.changeSetList.isEmptySet());
    }

    @Test
    public void testIsEmptySetReallyEmpty() {
        Assert.assertTrue((boolean)this.emptyChangeSetList.isEmptySet());
    }

    @Test
    public void testIterator() {
        Iterator iterator = this.changeSetList.iterator();
        GitChangeSet firstChangeSet = (GitChangeSet)iterator.next();
        Assert.assertThat((Object)firstChangeSet, (Matcher)Matchers.is((Object)this.changeSet));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReallyE() {
        Iterator iterator = this.emptyChangeSetList.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testGetLogs() {
        List result = this.changeSetList.getLogs();
        Assert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new GitChangeSet[]{this.changeSet}));
    }

    @Test
    public void testGetLogsReallyEmpty() {
        List result = this.emptyChangeSetList.getLogs();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetKind() {
        Assert.assertThat((Object)this.changeSetList.getKind(), (Matcher)Matchers.is((Object)"git"));
    }
}

