/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetUtil;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitChangeSetSimpleTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private GitChangeSet changeSet = null;
    private final boolean useAuthorName;
    private final boolean useLegacyFormat;

    public GitChangeSetSimpleTest(String useAuthorName, String useLegacyFormat) {
        this.useAuthorName = Boolean.valueOf(useAuthorName);
        this.useLegacyFormat = Boolean.valueOf(useLegacyFormat);
    }

    @Parameterized.Parameters(name="{0},{1}")
    public static Collection permuteAuthorNameAndLegacyLayout() {
        String[] allowed;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String authorName : allowed = new String[]{"true", "false"}) {
            for (String legacyFormat : allowed) {
                Object[] combination = new Object[]{authorName, legacyFormat};
                values.add(combination);
            }
        }
        return values;
    }

    @Before
    public void createSimpleChangeSet() {
        this.changeSet = GitChangeSetUtil.genChangeSet(this.useAuthorName, this.useLegacyFormat);
    }

    @Test
    public void testChangeSetDetails() {
        Assert.assertEquals((Object)"123abc456def", (Object)this.changeSet.getId());
        Assert.assertEquals((Object)"Commit title.", (Object)this.changeSet.getMsg());
        Assert.assertEquals((Object)"Commit title.\nCommit extended description.\n", (Object)this.changeSet.getComment());
        HashSet<String> expectedAffectedPaths = new HashSet<String>(7);
        expectedAffectedPaths.add("src/test/add.file");
        expectedAffectedPaths.add("src/test/deleted.file");
        expectedAffectedPaths.add("src/test/modified.file");
        expectedAffectedPaths.add("src/test/renamedFrom.file");
        expectedAffectedPaths.add("src/test/renamedTo.file");
        expectedAffectedPaths.add("src/test/copyOf.file");
        Assert.assertEquals(expectedAffectedPaths, (Object)this.changeSet.getAffectedPaths());
        Collection actualPaths = this.changeSet.getPaths();
        Assert.assertEquals((long)6L, (long)actualPaths.size());
        block16: for (GitChangeSet.Path path : actualPaths) {
            if (null == path.getPath()) continue;
            switch (path.getPath()) {
                case "src/test/add.file": {
                    Assert.assertEquals((Object)EditType.ADD, (Object)path.getEditType());
                    Assert.assertNull((Object)path.getSrc());
                    Assert.assertEquals((Object)"123abc456def789abc012def345abc678def901a", (Object)path.getDst());
                    continue block16;
                }
                case "src/test/deleted.file": {
                    Assert.assertEquals((Object)EditType.DELETE, (Object)path.getEditType());
                    Assert.assertEquals((Object)"123abc456def789abc012def345abc678def901a", (Object)path.getSrc());
                    Assert.assertNull((Object)path.getDst());
                    continue block16;
                }
                case "src/test/modified.file": {
                    Assert.assertEquals((Object)EditType.EDIT, (Object)path.getEditType());
                    Assert.assertEquals((Object)"123abc456def789abc012def345abc678def901a", (Object)path.getSrc());
                    Assert.assertEquals((Object)"bc234def567abc890def123abc456def789abc01", (Object)path.getDst());
                    continue block16;
                }
                case "src/test/renamedFrom.file": {
                    Assert.assertEquals((Object)EditType.DELETE, (Object)path.getEditType());
                    Assert.assertEquals((Object)"123abc456def789abc012def345abc678def901a", (Object)path.getSrc());
                    Assert.assertEquals((Object)"bc234def567abc890def123abc456def789abc01", (Object)path.getDst());
                    continue block16;
                }
                case "src/test/renamedTo.file": {
                    Assert.assertEquals((Object)EditType.ADD, (Object)path.getEditType());
                    Assert.assertEquals((Object)"123abc456def789abc012def345abc678def901a", (Object)path.getSrc());
                    Assert.assertEquals((Object)"bc234def567abc890def123abc456def789abc01", (Object)path.getDst());
                    continue block16;
                }
                case "src/test/copyOf.file": {
                    Assert.assertEquals((Object)EditType.ADD, (Object)path.getEditType());
                    Assert.assertEquals((Object)"bc234def567abc890def123abc456def789abc01", (Object)path.getSrc());
                    Assert.assertEquals((Object)"123abc456def789abc012def345abc678def901a", (Object)path.getDst());
                    continue block16;
                }
            }
            Assert.fail((String)"Unrecognized path.");
        }
    }

    @Test
    public void testGetCommitId() {
        Assert.assertEquals((Object)"123abc456def", (Object)this.changeSet.getCommitId());
    }

    @Test
    public void testSetParent() {
        this.changeSet.setParent(null);
        Assert.assertNull((Object)this.changeSet.getParent());
    }

    @Test
    public void testGetParentCommit() {
        Assert.assertEquals((Object)"345mno678pqr", (Object)this.changeSet.getParentCommit());
    }

    @Test
    public void testGetAffectedFiles() {
        Assert.assertEquals((long)6L, (long)this.changeSet.getAffectedFiles().size());
    }

    @Test
    public void testGetAuthorName() {
        Assert.assertEquals((Object)(this.useAuthorName ? "John Author" : "John Committer"), (Object)this.changeSet.getAuthorName());
    }

    @Test
    public void testGetDate() {
        Assert.assertEquals((Object)(this.useAuthorName ? "1970-01-15T06:56:08-0600" : "1970-01-15T06:56:06-0600"), (Object)this.changeSet.getDate());
    }

    @Test
    public void testGetMsg() {
        Assert.assertEquals((Object)"Commit title.", (Object)this.changeSet.getMsg());
    }

    @Test
    public void testGetId() {
        Assert.assertEquals((Object)"123abc456def", (Object)this.changeSet.getId());
    }

    @Test
    public void testGetRevision() {
        Assert.assertEquals((Object)"123abc456def", (Object)this.changeSet.getRevision());
    }

    @Test
    public void testGetComment() {
        String changeComment = this.changeSet.getComment();
        Assert.assertTrue((String)("Comment '" + changeComment + "' does not start with '" + "Commit title.\n" + "'"), (boolean)changeComment.startsWith("Commit title.\n"));
    }

    @Test
    public void testGetBranch() {
        Assert.assertNull((Object)this.changeSet.getBranch());
    }

    @Test
    public void testHashCode() {
        Assert.assertTrue((this.changeSet.hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.changeSet.equals((Object)this.changeSet));
        Assert.assertFalse((boolean)this.changeSet.equals((Object)new GitChangeSet(new ArrayList(), false)));
    }

    @Test
    public void testChangeSetExceptionMessage() {
        String expectedLineContent = "commit ";
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("commit ");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Commit has no ID[commit ]");
        GitChangeSet badChangeSet = new GitChangeSet(lines, true);
    }
}

