/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetUtil;
import hudson.tasks.Mailer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitChangeSetTest {
    @Rule
    public JenkinsRule jenkins = new JenkinsRule();

    @Test
    public void testFindOrCreateUser() {
        GitChangeSet committerCS = GitChangeSetUtil.genChangeSet(false, false);
        String email = "jauthor@nospam.com";
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = false;
        User user = committerCS.findOrCreateUser("John Author", "jauthor@nospam.com", true, false);
        Assert.assertNotNull((Object)user);
        Mailer.UserProperty property = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        Assert.assertNotNull((Object)property);
        String address = property.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)"jauthor@nospam.com", (Object)address);
        Assert.assertEquals((Object)User.getUnknown(), (Object)committerCS.findOrCreateUser(null, "jauthor@nospam.com", false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)committerCS.findOrCreateUser(null, "jauthor@nospam.com", true, false));
    }

    @Test
    public void testFindOrCreateUserBasedOnExistingUsersEmail() throws IOException {
        GitChangeSet committerCS = GitChangeSetUtil.genChangeSet(true, false);
        String existingUserId = "An existing user";
        String existingUserFullName = "Some FullName";
        String email = "jcommitter@nospam.com";
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = true;
        Assert.assertNull((Object)User.get((String)"jcommitter@nospam.com", (boolean)false));
        User existingUser = User.get((String)"An existing user", (boolean)true);
        existingUser.setFullName("Some FullName");
        existingUser.addProperty((UserProperty)new Mailer.UserProperty("jcommitter@nospam.com"));
        User user = committerCS.findOrCreateUser("John Committer", "jcommitter@nospam.com", true, true);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getId(), (Object)"An existing user");
        Assert.assertEquals((Object)user.getFullName(), (Object)"Some FullName");
        Mailer.UserProperty property = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        Assert.assertNotNull((Object)property);
        String address = property.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)"jcommitter@nospam.com", (Object)address);
        Assert.assertEquals((Object)User.getUnknown(), (Object)committerCS.findOrCreateUser(null, "jcommitter@nospam.com", false, true));
        Assert.assertEquals((Object)User.getUnknown(), (Object)committerCS.findOrCreateUser(null, "jcommitter@nospam.com", true, true));
    }

    @Test
    public void findOrCreateByFullName() throws Exception {
        GitChangeSet cs = GitChangeSetUtil.genChangeSet(false, false);
        User user = User.get((String)"john");
        user.setFullName("John Committer");
        user.addProperty((UserProperty)new Mailer.UserProperty("jcommitter@nospam.com"));
        Assert.assertEquals((Object)user, (Object)cs.getAuthor());
    }
}

