/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.plugins.git.AbstractGitProject;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitPublisher;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.LongRunningCommit;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.PreBuildMerge;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import jenkins.model.Jenkins;
import jenkins.plugins.git.CliGitCommand;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GitPublisherTest
extends AbstractGitProject {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @BeforeClass
    public static void setGitDefaults() throws Exception {
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        gitCmd.setDefaults();
    }

    @Test
    public void testMatrixBuild() throws Exception {
        final AtomicInteger run = new AtomicInteger();
        this.commitNewFile("a");
        MatrixProject mp = (MatrixProject)this.jenkins.createProject(MatrixProject.class, "xyz");
        mp.setAxes(new AxisList(new Axis[]{new Axis("VAR", new String[]{"a", "b"})}));
        mp.setScm((SCM)new GitSCM(this.testGitDir.getAbsolutePath()));
        mp.getPublishersList().add((Object)new GitPublisher(Collections.singletonList(new GitPublisher.TagToPush("origin", "foo", "message", true, false)), Collections.emptyList(), Collections.emptyList(), true, true, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
                run.incrementAndGet();
                try {
                    boolean bl = super.perform(build, launcher, listener);
                    return bl;
                }
                finally {
                    if (run.get() < 3) {
                        Assert.assertFalse((boolean)GitPublisherTest.this.existsTag("foo"));
                    }
                }
            }

            public BuildStepDescriptor getDescriptor() {
                return (BuildStepDescriptor)Jenkins.get().getDescriptorOrDie(GitPublisher.class);
            }

            private Object writeReplace() {
                return new NullSCM();
            }
        });
        MatrixBuild b = (MatrixBuild)this.jenkins.assertBuildStatusSuccess((Run)mp.scheduleBuild2(0).get());
        Assert.assertTrue((boolean)this.existsTag("foo"));
        Assert.assertTrue((boolean)this.containsTagMessage("foo", "message"));
        Assert.assertEquals((long)3L, (long)run.get());
    }

    @Test
    public void testMergeAndPush() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.remoteConfigs(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, null)));
        scm.getExtensions().add((Object)new LocalBranch("integration"));
        project.setScm((SCM)scm);
        project.getPublishersList().add((Object)new GitPublisher(Collections.emptyList(), Collections.singletonList(new GitPublisher.BranchToPush("origin", "integration")), Collections.emptyList(), true, true, false));
        this.commitNewFile("commitFileBase");
        this.testGitClient.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testGitClient.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commitNewFile("commitFile1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        String sha1 = this.getHeadRevision((AbstractBuild)build1, "integration");
        Assert.assertEquals((Object)sha1, (Object)this.testGitClient.revParse("HEAD").name());
    }

    @Test
    public void testMergeAndPushFF() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.remoteConfigs(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, MergeCommand.GitPluginFastForwardMode.FF)));
        scm.getExtensions().add((Object)new LocalBranch("integration"));
        project.setScm((SCM)scm);
        project.getPublishersList().add((Object)new GitPublisher(Collections.emptyList(), Collections.singletonList(new GitPublisher.BranchToPush("origin", "integration")), Collections.emptyList(), true, true, false));
        this.commitNewFile("commitFileBase");
        this.testGitClient.branch("integration");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFileBase");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFileBase").exists());
        String shaIntegration = this.getHeadRevision((AbstractBuild)build1, "integration");
        Assert.assertEquals((String)"the integration branch should be at HEAD", (Object)shaIntegration, (Object)this.testGitClient.revParse("HEAD").name());
        this.testGitClient.checkout("master");
        ObjectId master = this.testGitClient.revParse("HEAD");
        this.testGitClient.branch("branch1");
        this.testGitClient.checkout("branch1");
        String commitFile1 = "commitFile1";
        this.commitNewFile("commitFile1");
        String shaBranch1 = this.testGitClient.revParse("branch1").name();
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile1").exists());
        shaIntegration = this.getHeadRevision((AbstractBuild)build2, "integration");
        String shaHead = this.testGitClient.revParse("HEAD").name();
        Assert.assertEquals((String)"the integration branch and branch1 should line up", (Object)shaIntegration, (Object)shaBranch1);
        Assert.assertEquals((String)"the integration branch should be at HEAD", (Object)shaIntegration, (Object)shaHead);
        List revList = this.testGitClient.revList("integration^1");
        ObjectId integrationParent = (ObjectId)revList.get(0);
        Assert.assertEquals((String)"Fast-forward merge should have had master as a parent", (Object)master, (Object)integrationParent);
        this.testGitClient.checkout("master");
        this.testGitClient.branch("branch2");
        this.testGitClient.checkout("branch2");
        String commitFile2 = "commitFile2";
        this.commitNewFile("commitFile2");
        String shaBranch2 = this.testGitClient.revParse("branch2").name();
        FreeStyleBuild build3 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile2").exists());
        revList = this.testGitClient.revList("integration^1");
        Assert.assertEquals((String)"Integration should have branch1 as a parent", (Object)((ObjectId)revList.get(0)).name(), (Object)shaBranch1);
        revList = this.testGitClient.revList("integration^2");
        Assert.assertEquals((String)"Integration should have branch2 as a parent", (Object)((ObjectId)revList.get(0)).name(), (Object)shaBranch2);
    }

    @Test
    public void testMergeAndPushNoFF() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.remoteConfigs(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, MergeCommand.GitPluginFastForwardMode.NO_FF)));
        scm.getExtensions().add((Object)new LocalBranch("integration"));
        project.setScm((SCM)scm);
        project.getPublishersList().add((Object)new GitPublisher(Collections.emptyList(), Collections.singletonList(new GitPublisher.BranchToPush("origin", "integration")), Collections.emptyList(), true, true, false));
        this.commitNewFile("commitFileBase");
        this.testGitClient.branch("integration");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFileBase");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFileBase").exists());
        String shaIntegration = this.getHeadRevision((AbstractBuild)build1, "integration");
        Assert.assertEquals((String)"integration branch should be at HEAD", (Object)shaIntegration, (Object)this.testGitClient.revParse("HEAD").name());
        this.testGitClient.checkout("master");
        ObjectId master = this.testGitClient.revParse("HEAD");
        this.testGitClient.branch("branch1");
        this.testGitClient.checkout("branch1");
        String commitFile1 = "commitFile1";
        this.commitNewFile("commitFile1");
        String shaBranch1 = this.testGitClient.revParse("branch1").name();
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile1");
        ObjectId mergeCommit = this.testGitClient.revParse("integration");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile1").exists());
        List revList = this.testGitClient.revList("integration^1");
        Assert.assertEquals((String)"Integration should have master as a parent", revList.get(0), (Object)master);
        revList = this.testGitClient.revList("integration^2");
        Assert.assertEquals((String)"Integration should have branch1 as a parent", (Object)((ObjectId)revList.get(0)).name(), (Object)shaBranch1);
        this.testGitClient.checkout("master");
        this.testGitClient.branch("branch2");
        this.testGitClient.checkout("branch2");
        String commitFile2 = "commitFile2";
        this.commitNewFile("commitFile2");
        String shaBranch2 = this.testGitClient.revParse("branch2").name();
        FreeStyleBuild build3 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((String)"commitFile1 should exist in the workspace", (boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertTrue((String)"commitFile2 should exist in the workspace", (boolean)build1.getWorkspace().child("commitFile2").exists());
        revList = this.testGitClient.revList("integration^1");
        Assert.assertEquals((String)"Integration should have the first merge commit as a parent", revList.get(0), (Object)mergeCommit);
        revList = this.testGitClient.revList("integration^2");
        Assert.assertEquals((String)"Integration should have branch2 as a parent", (Object)((ObjectId)revList.get(0)).name(), (Object)shaBranch2);
    }

    @Test
    public void testMergeAndPushFFOnly() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.remoteConfigs(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, MergeCommand.GitPluginFastForwardMode.FF_ONLY)));
        scm.getExtensions().add((Object)new LocalBranch("integration"));
        project.setScm((SCM)scm);
        project.getPublishersList().add((Object)new GitPublisher(Collections.emptyList(), Collections.singletonList(new GitPublisher.BranchToPush("origin", "integration")), Collections.emptyList(), true, true, false));
        this.commitNewFile("commitFileBase");
        this.testGitClient.branch("integration");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFileBase");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFileBase").exists());
        String shaIntegration = this.getHeadRevision((AbstractBuild)build1, "integration");
        Assert.assertEquals((String)"integration should be at HEAD", (Object)shaIntegration, (Object)this.testGitClient.revParse("HEAD").name());
        this.testGitClient.checkout("master");
        ObjectId master = this.testGitClient.revParse("HEAD");
        this.testGitClient.branch("branch1");
        this.testGitClient.checkout("branch1");
        String commitFile1 = "commitFile1";
        this.commitNewFile("commitFile1");
        String shaBranch1 = this.testGitClient.revParse("branch1").name();
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile1");
        ObjectId mergeCommit = this.testGitClient.revParse("integration");
        Assert.assertTrue((String)"commitFile1 should exist in the workspace", (boolean)build2.getWorkspace().child("commitFile1").exists());
        shaIntegration = this.getHeadRevision((AbstractBuild)build2, "integration");
        String shaHead = this.testGitClient.revParse("HEAD").name();
        Assert.assertEquals((String)"integration and branch1 should line up", (Object)shaIntegration, (Object)shaBranch1);
        Assert.assertEquals((String)"integration and head should line up", (Object)shaIntegration, (Object)shaHead);
        List revList = this.testGitClient.revList("integration^1");
        ObjectId integrationParent = (ObjectId)revList.get(0);
        Assert.assertEquals((String)"Fast-forward merge should have had master as a parent", (Object)master, (Object)integrationParent);
        this.testGitClient.checkout("master");
        this.testGitClient.branch("branch2");
        this.testGitClient.checkout("branch2");
        String commitFile2 = "commitFile2";
        this.commitNewFile("commitFile2");
        String shaBranch2 = this.testGitClient.revParse("branch2").name();
        FreeStyleBuild build3 = this.build(project, Result.FAILURE, "commitFile2");
        Assert.assertFalse((String)"commitFile1 should not exist in the workspace", (boolean)build2.getWorkspace().child("commitFile1").exists());
        Assert.assertTrue((String)"commitFile2 should exist in the workspace", (boolean)build2.getWorkspace().child("commitFile2").exists());
        revList = this.testGitClient.revList("branch2^1");
        Assert.assertEquals((String)"branch2 should have master as a parent", revList.get(0), (Object)master);
        try {
            revList = this.testGitClient.revList("branch2^2");
            Assert.assertTrue((String)"branch2 should have no other parent than master", (boolean)false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPushEnvVarsInRemoteConfig() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        TestGitRepo testTargetRepo = new TestGitRepo("target", this.tmpFolder.newFolder("push_env_vars"), (TaskListener)listener);
        testTargetRepo.git.init_().workspace(testTargetRepo.gitDir.getAbsolutePath()).bare(true).execute();
        testTargetRepo.commit("lostTargetFile", new PersonIdent("John Doe", "john@example.com"), "Initial Target Commit");
        List<UserRemoteConfig> remoteRepositories = this.remoteConfigs();
        remoteRepositories.add(new UserRemoteConfig("$TARGET_URL", "$TARGET_NAME", "+refs/heads/$TARGET_BRANCH:refs/remotes/$TARGET_NAME/$TARGET_BRANCH", null));
        GitSCM scm = new GitSCM(remoteRepositories, Collections.singletonList(new BranchSpec("origin/master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("TARGET_URL", testTargetRepo.gitDir.getAbsolutePath()), new StringParameterDefinition("TARGET_NAME", "target"), new StringParameterDefinition("TARGET_BRANCH", "master")}));
        String tag_name = "test-tag";
        String note_content = "Test Note";
        project.getPublishersList().add((Object)new GitPublisher(Collections.singletonList(new GitPublisher.TagToPush("$TARGET_NAME", tag_name, "", false, false)), Collections.singletonList(new GitPublisher.BranchToPush("$TARGET_NAME", "$TARGET_BRANCH")), Collections.singletonList(new GitPublisher.NoteToPush("$TARGET_NAME", note_content, "refs/notes/commits", false)), true, false, true));
        this.commitNewFile("commitFile");
        this.testGitClient.tag(tag_name, "Comment");
        ObjectId expectedCommit = this.testGitClient.revParse("master");
        this.build(project, Result.SUCCESS, "commitFile");
        Assert.assertEquals((Object)expectedCommit, (Object)testTargetRepo.git.revParse("master"));
        Assert.assertTrue((boolean)this.existsTagInRepo(testTargetRepo.git, tag_name));
    }

    @Test
    public void testForcePush() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.remoteConfigs(), Collections.singletonList(new BranchSpec("master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        GitPublisher forcedPublisher = new GitPublisher(Collections.emptyList(), Collections.singletonList(new GitPublisher.BranchToPush("origin", "otherbranch")), Collections.emptyList(), true, true, true);
        project.getPublishersList().add((Object)forcedPublisher);
        this.commitNewFile("commitFile");
        ObjectId masterCommit1 = this.testGitClient.revParse("master");
        this.testGitClient.branch("otherbranch");
        this.testGitClient.checkout("otherbranch");
        this.commitNewFile("otherCommitFile");
        ObjectId otherCommit = this.testGitClient.revParse("otherbranch");
        this.testGitClient.checkout("master");
        this.commitNewFile("commitFile2");
        ObjectId masterCommit2 = this.testGitClient.revParse("master");
        Assert.assertEquals((Object)masterCommit1, (Object)this.testGitClient.revParse("master^"));
        Assert.assertEquals((Object)masterCommit1, (Object)this.testGitClient.revParse("otherbranch^"));
        Assert.assertEquals((Object)otherCommit, (Object)this.testGitClient.revParse("otherbranch"));
        Assert.assertTrue((String)"otherCommit not in otherbranch", (boolean)this.testGitClient.revList("otherbranch").contains(otherCommit));
        this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertEquals((Object)masterCommit2, (Object)this.testGitClient.revParse("otherbranch"));
        Assert.assertFalse((String)"otherCommit in otherbranch", (boolean)this.testGitClient.revList("otherbranch").contains(otherCommit));
        this.testGitClient.checkout("otherbranch");
        this.commitNewFile("otherCommitFile2");
        ObjectId otherCommit2 = this.testGitClient.revParse("otherbranch");
        Assert.assertNotEquals((Object)masterCommit2, (Object)otherCommit2);
        this.testGitClient.checkout("master");
        this.commitNewFile("commitFile3");
        ObjectId masterCommit3 = this.testGitClient.revParse("master");
        project.getPublishersList().remove((Object)forcedPublisher);
        GitPublisher unforcedPublisher = new GitPublisher(Collections.emptyList(), Collections.singletonList(new GitPublisher.BranchToPush("origin", "otherbranch")), Collections.emptyList(), true, true, false);
        project.getPublishersList().add((Object)unforcedPublisher);
        Assert.assertEquals((Object)otherCommit2, (Object)this.testGitClient.revParse("otherbranch"));
        Assert.assertTrue((String)"otherCommit2 not in otherbranch", (boolean)this.testGitClient.revList("otherbranch").contains(otherCommit2));
        this.build(project, Result.FAILURE, "commitFile3");
        Assert.assertEquals((Object)otherCommit2, (Object)this.testGitClient.revParse("otherbranch"));
        Assert.assertTrue((String)"otherCommit2 not in otherbranch", (boolean)this.testGitClient.revList("otherbranch").contains(otherCommit2));
        project.getPublishersList().remove((Object)unforcedPublisher);
        project.getPublishersList().add((Object)forcedPublisher);
        this.testGitClient.checkout("master");
        this.commitNewFile("commitFile4");
        ObjectId masterCommit4 = this.testGitClient.revParse("master");
        Assert.assertEquals((Object)otherCommit2, (Object)this.testGitClient.revParse("otherbranch"));
        Assert.assertTrue((String)"otherCommit2 not in test repo", (boolean)this.testGitClient.isCommitInRepo(otherCommit2));
        Assert.assertTrue((String)"otherCommit2 not in otherbranch", (boolean)this.testGitClient.revList("otherbranch").contains(otherCommit2));
        this.build(project, Result.SUCCESS, "commitFile4");
        Assert.assertEquals((Object)masterCommit4, (Object)this.testGitClient.revParse("otherbranch"));
        Assert.assertEquals((Object)masterCommit3, (Object)this.testGitClient.revParse("otherbranch^"));
        Assert.assertFalse((String)"otherCommit2 in otherbranch", (boolean)this.testGitClient.revList("otherbranch").contains(otherCommit2));
    }

    @Test
    public void testMergeAndPushWithSkipTagEnabled() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.remoteConfigs(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, new ArrayList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, null)));
        scm.getExtensions().add((Object)new LocalBranch("integration"));
        project.setScm((SCM)scm);
        project.getPublishersList().add((Object)new GitPublisher(Collections.emptyList(), Collections.singletonList(new GitPublisher.BranchToPush("origin", "integration")), Collections.emptyList(), true, true, false));
        this.commitNewFile("commitFileBase");
        this.testGitClient.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testGitClient.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commitNewFile("commitFile1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        String sha1 = this.getHeadRevision((AbstractBuild)build1, "integration");
        Assert.assertEquals((Object)sha1, (Object)this.testGitClient.revParse("HEAD").name());
    }

    @Test
    public void testRebaseBeforePush() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.remoteConfigs(), Collections.singletonList(new BranchSpec("master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        GitPublisher.BranchToPush btp = new GitPublisher.BranchToPush("origin", "master");
        btp.setRebaseBeforePush(true);
        GitPublisher rebasedPublisher = new GitPublisher(Collections.emptyList(), Collections.singletonList(btp), Collections.emptyList(), true, true, true);
        project.getPublishersList().add((Object)rebasedPublisher);
        project.getBuildersList().add((Object)new LongRunningCommit(this.testGitDir));
        project.save();
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1", "commitFile2");
    }

    @Test
    public void testMergeAndPushWithCharacteristicEnvVar() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String envName = "JENKINS_SERVER_COOKIE";
        String envValue = project.getCharacteristicEnvVars().get(envName, "NOT-SET");
        Assert.assertFalse((String)("Env " + envName + " not set"), (boolean)envValue.equals("NOT-SET"));
        this.checkEnvVar(project, envName, envValue);
    }

    @Test
    public void testMergeAndPushWithSystemEnvVar() throws Exception {
        String envName = this.isWindows() ? "COMPUTERNAME" : "LOGNAME";
        String envValue = System.getenv().get(envName);
        Assume.assumeThat((Object)envValue, (Matcher)Matchers.notNullValue());
        Assume.assumeThat((Object)envValue, (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        FreeStyleProject project = this.setupSimpleProject("master");
        Assert.assertNotNull((String)("Env " + envName + " not set"), (Object)envValue);
        Assert.assertFalse((String)("Env " + envName + " empty"), (boolean)envValue.isEmpty());
        this.checkEnvVar(project, envName, envValue);
    }

    private void checkEnvVar(FreeStyleProject project, String envName, String envValue) throws Exception {
        String envReference = "${" + envName + "}";
        ArrayList<Object> scmExtensions = new ArrayList<Object>();
        scmExtensions.add(new PreBuildMerge(new UserMergeOptions("origin", envReference, null, null)));
        scmExtensions.add(new LocalBranch(envReference));
        GitSCM scm = new GitSCM(this.remoteConfigs(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, scmExtensions);
        project.setScm((SCM)scm);
        String tagNameReference = envReference + "-tag";
        String tagNameValue = envValue + "-tag";
        String tagMessageReference = envReference + " tag message";
        String noteReference = "note for " + envReference;
        String noteValue = "note for " + envValue;
        GitPublisher publisher = new GitPublisher(Collections.singletonList(new GitPublisher.TagToPush("origin", tagNameReference, tagMessageReference, false, true)), Collections.singletonList(new GitPublisher.BranchToPush("origin", envReference)), Collections.singletonList(new GitPublisher.NoteToPush("origin", noteReference, "refs/notes/commits", false)), true, true, true);
        Assert.assertTrue((boolean)publisher.isForcePush());
        Assert.assertTrue((boolean)publisher.isPushBranches());
        Assert.assertTrue((boolean)publisher.isPushMerge());
        Assert.assertTrue((boolean)publisher.isPushNotes());
        Assert.assertTrue((boolean)publisher.isPushOnlyIfSuccess());
        Assert.assertTrue((boolean)publisher.isPushTags());
        project.getPublishersList().add((Object)publisher);
        this.commitNewFile("commitFileBase");
        ObjectId initialCommit = this.testGitClient.getHeadRev(this.testGitDir.getAbsolutePath(), "master");
        Assert.assertTrue((boolean)this.testGitClient.isCommitInRepo(initialCommit));
        Assert.assertFalse((String)("Test repo has " + envValue + " branch"), (boolean)this.hasBranch(envValue));
        this.testGitClient.branch(envValue);
        Assert.assertTrue((String)("Test repo missing " + envValue + " branch"), (boolean)this.hasBranch(envValue));
        Assert.assertFalse((String)(tagNameValue + " in " + this.testGitClient), (boolean)this.testGitClient.tagExists(tagNameValue));
        FreeStyleBuild build0 = this.build(project, Result.SUCCESS, "commitFileBase");
        String build0HeadBranch = this.getHeadRevision((AbstractBuild)build0, envValue);
        Assert.assertEquals((Object)build0HeadBranch, (Object)initialCommit.getName());
        Assert.assertTrue((String)(tagNameValue + " not in " + this.testGitClient), (boolean)this.testGitClient.tagExists(tagNameValue));
        Assert.assertTrue((String)(tagNameValue + " not in build"), (boolean)build0.getWorkspace().child(".git/refs/tags/" + tagNameValue).exists());
        String topicBranch = envValue + "-topic1";
        Assert.assertFalse((String)("Test repo has " + topicBranch + " branch"), (boolean)this.hasBranch(topicBranch));
        this.testGitClient.checkout(null, topicBranch);
        Assert.assertTrue((String)("Test repo has no " + topicBranch + " branch"), (boolean)this.hasBranch(topicBranch));
        String commitFile1 = "commitFile1";
        this.commitNewFile("commitFile1");
        ObjectId topicCommit = this.testGitClient.getHeadRev(this.testGitDir.getAbsolutePath(), topicBranch);
        Assert.assertTrue((boolean)this.testGitClient.isCommitInRepo(topicCommit));
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        FilePath myWorkspace = build1.getWorkspace();
        Assert.assertTrue((boolean)myWorkspace.child("commitFile1").exists());
        Assert.assertTrue((String)("Tag " + tagNameValue + " not in build"), (boolean)myWorkspace.child(".git/refs/tags/" + tagNameValue).exists());
        String build1Head = this.getHeadRevision((AbstractBuild)build1, envValue);
        Assert.assertEquals((Object)build1Head, (Object)this.testGitClient.revParse("HEAD").name());
        Assert.assertEquals((String)"Wrong head commit in build1", (Object)topicCommit.getName(), (Object)build1Head);
    }

    private boolean existsTag(String tag) throws InterruptedException {
        return this.existsTagInRepo(this.testGitClient, tag);
    }

    private boolean existsTagInRepo(GitClient gitClient, String tag) throws InterruptedException {
        Set tags = gitClient.getTagNames("*");
        return tags.contains(tag);
    }

    private boolean containsTagMessage(String tag, String str) throws InterruptedException {
        String msg = this.testGitClient.getTagMessage(tag);
        return msg.contains(str);
    }

    private boolean hasBranch(String branchName) throws GitException, InterruptedException {
        Set testRepoBranches = this.testGitClient.getBranches();
        for (Branch branch : testRepoBranches) {
            if (!branch.getName().equals(branchName)) continue;
            return true;
        }
        return false;
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

