/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.AncestryBuildChooser;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.scm.RepositoryBrowser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GitSCMUnitTest {
    private final String gitDir = ".";
    private final GitSCM gitSCM = new GitSCM(".");
    private final String repoURL = "https://github.com/jenkinsci/git-plugin";

    @Test
    public void testGetSubmoduleCfg() {
        ArrayList emptySubmoduleConfigList = new ArrayList();
        Assert.assertThat((Object)this.gitSCM.getSubmoduleCfg(), (Matcher)Matchers.is(emptySubmoduleConfigList));
    }

    @Test
    public void testSetSubmoduleCfg() {
        ArrayList<SubmoduleConfig> submoduleConfigList = new ArrayList<SubmoduleConfig>();
        SubmoduleConfig config = new SubmoduleConfig();
        submoduleConfigList.add(config);
        this.gitSCM.setSubmoduleCfg(submoduleConfigList);
        Assert.assertThat((Object)this.gitSCM.getSubmoduleCfg(), (Matcher)Matchers.is(submoduleConfigList));
    }

    @Test
    public void testCreateRepoList() {
        String name = null;
        String refspec = null;
        String credentialsId = null;
        ArrayList<UserRemoteConfig> expectedRemoteConfigList = new ArrayList<UserRemoteConfig>();
        UserRemoteConfig remoteConfig = new UserRemoteConfig("https://github.com/jenkinsci/git-plugin", name, refspec, credentialsId);
        expectedRemoteConfigList.add(remoteConfig);
        List remoteConfigList = GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", credentialsId);
        this.assertUserRemoteConfigListEquals(remoteConfigList, expectedRemoteConfigList);
    }

    private void assertUserRemoteConfigListEquals(List<UserRemoteConfig> remoteConfigList, List<UserRemoteConfig> expectedRemoteConfigList) {
        Assert.assertThat((Object)remoteConfigList.toString(), (Matcher)Matchers.is((Object)expectedRemoteConfigList.toString()));
        Assert.assertThat((Object)remoteConfigList.get(0).getUrl(), (Matcher)Matchers.is((Object)expectedRemoteConfigList.get(0).getUrl()));
        Assert.assertThat((Object)remoteConfigList.get(0).getName(), (Matcher)Matchers.is((Object)expectedRemoteConfigList.get(0).getName()));
        Assert.assertThat((Object)remoteConfigList.get(0).getRefspec(), (Matcher)Matchers.is((Object)expectedRemoteConfigList.get(0).getRefspec()));
        Assert.assertThat((Object)remoteConfigList.get(0).getCredentialsId(), (Matcher)Matchers.is((Object)expectedRemoteConfigList.get(0).getCredentialsId()));
        Assert.assertThat((Object)remoteConfigList.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGetBrowser() {
        Assert.assertThat((Object)this.gitSCM.getBrowser(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetBrowser() {
        GithubWeb browser = new GithubWeb("https://github.com/jenkinsci/git-plugin");
        this.gitSCM.setBrowser((GitRepositoryBrowser)browser);
        Assert.assertThat((Object)this.gitSCM.getBrowser(), (Matcher)Matchers.is((Object)browser));
    }

    @Test
    public void testGuessBrowser() {
        RepositoryBrowser result = this.gitSCM.guessBrowser();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetBuildChooser() {
        Assert.assertThat((Object)this.gitSCM.getBuildChooser(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultBuildChooser.class)));
    }

    @Test
    public void testSetBuildChooser() throws Exception {
        AncestryBuildChooser ancestryBuildChooser = new AncestryBuildChooser(Integer.valueOf(1), "string");
        this.gitSCM.setBuildChooser((BuildChooser)ancestryBuildChooser);
        Assert.assertThat((Object)this.gitSCM.getBuildChooser(), (Matcher)Matchers.is((Object)ancestryBuildChooser));
    }

    @Test
    public void testSetBuildChooserDefault() throws Exception {
        AncestryBuildChooser ancestryBuildChooser = new AncestryBuildChooser(Integer.valueOf(1), "string");
        this.gitSCM.setBuildChooser((BuildChooser)ancestryBuildChooser);
        DefaultBuildChooser defaultBuildChooser = new DefaultBuildChooser();
        this.gitSCM.setBuildChooser((BuildChooser)defaultBuildChooser);
        Assert.assertThat((Object)this.gitSCM.getBuildChooser(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultBuildChooser.class)));
    }

    @Test
    public void testGetRepositoryByName() throws Exception {
        RemoteConfig expected = new RemoteConfig(new Config(), "origin");
        expected.addURI(new URIish("."));
        this.assertRemoteConfigEquals(this.gitSCM.getRepositoryByName("origin"), expected);
    }

    private void assertRemoteConfigEquals(RemoteConfig remoteConfig, RemoteConfig expected) {
        Assert.assertThat((Object)remoteConfig.getName(), (Matcher)Matchers.is((Object)expected.getName()));
        Assert.assertThat((Object)remoteConfig.getURIs(), (Matcher)Matchers.is((Object)expected.getURIs()));
    }

    private void assertRemoteConfigListEquals(List<RemoteConfig> remoteConfigList, List<RemoteConfig> expectedList) {
        int expectedIndex = 0;
        for (RemoteConfig remoteConfig : remoteConfigList) {
            this.assertRemoteConfigEquals(remoteConfig, expectedList.get(expectedIndex++));
        }
    }

    @Test
    public void testGetRepositoryByNameNoSuchName() {
        Assert.assertThat((Object)this.gitSCM.getRepositoryByName("no-such-name"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetRepositoryByNameEmptyName() {
        Assert.assertThat((Object)this.gitSCM.getRepositoryByName(""), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetRepositoryByNameNullName() {
        Assert.assertThat((Object)this.gitSCM.getRepositoryByName(null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetUserRemoteConfigs() {
        String name = null;
        String refspec = null;
        String credentialsId = null;
        ArrayList<UserRemoteConfig> expectedRemoteConfigList = new ArrayList<UserRemoteConfig>();
        UserRemoteConfig remoteConfig = new UserRemoteConfig(".", name, refspec, credentialsId);
        expectedRemoteConfigList.add(remoteConfig);
        this.assertUserRemoteConfigListEquals(this.gitSCM.getUserRemoteConfigs(), expectedRemoteConfigList);
    }

    @Test
    public void testGetRepositories() throws Exception {
        ArrayList<RemoteConfig> expectedRemoteConfigList = new ArrayList<RemoteConfig>();
        RemoteConfig remoteConfig = new RemoteConfig(new Config(), "origin");
        remoteConfig.addURI(new URIish("."));
        expectedRemoteConfigList.add(remoteConfig);
        this.assertRemoteConfigListEquals(this.gitSCM.getRepositories(), expectedRemoteConfigList);
    }

    @Test
    public void testDeriveLocalBranchName() {
        Assert.assertThat((Object)this.gitSCM.deriveLocalBranchName("origin/master"), (Matcher)Matchers.is((Object)"master"));
        Assert.assertThat((Object)this.gitSCM.deriveLocalBranchName("master"), (Matcher)Matchers.is((Object)"master"));
        Assert.assertThat((Object)this.gitSCM.deriveLocalBranchName("origin/feature/xyzzy"), (Matcher)Matchers.is((Object)"feature/xyzzy"));
        Assert.assertThat((Object)this.gitSCM.deriveLocalBranchName("feature/xyzzy"), (Matcher)Matchers.is((Object)"feature/xyzzy"));
    }

    @Test
    public void testGetGitTool() {
        Assert.assertThat((Object)this.gitSCM.getGitTool(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetParameterString() {
        String original = "${A}/${B} ${A}/${C}";
        EnvVars env = new EnvVars();
        env.put("A", "A-value");
        env.put("B", "B-value");
        Assert.assertThat((Object)GitSCM.getParameterString((String)original, (EnvVars)env), (Matcher)Matchers.is((Object)"A-value/B-value A-value/${C}"));
    }

    @Test
    public void testRequiresWorkspaceForPolling() {
        Assert.assertTrue((boolean)this.gitSCM.requiresWorkspaceForPolling());
    }

    @Test
    public void testRequiresWorkspaceForPollingSingleBranch() {
        GitSCM bigGitSCM = new GitSCM(GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", null), Collections.singletonList(new BranchSpec("master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        Assert.assertFalse((boolean)bigGitSCM.requiresWorkspaceForPolling());
    }

    @Test
    public void testRequiresWorkspaceForPollingSingleBranchWithRemoteName() {
        GitSCM bigGitSCM = new GitSCM(GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", null), Collections.singletonList(new BranchSpec("origin/master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        Assert.assertFalse((boolean)bigGitSCM.requiresWorkspaceForPolling());
    }

    @Test
    public void testRequiresWorkspaceForPollingSingleBranchWithWildcardRemoteName() {
        GitSCM bigGitSCM = new GitSCM(GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", null), Collections.singletonList(new BranchSpec("*/master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        Assert.assertFalse((boolean)bigGitSCM.requiresWorkspaceForPolling());
    }

    @Test
    public void testRequiresWorkspaceForPollingSingleBranchWithWildcardSuffix() {
        GitSCM bigGitSCM = new GitSCM(GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", null), Collections.singletonList(new BranchSpec("master*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        Assert.assertTrue((boolean)bigGitSCM.requiresWorkspaceForPolling());
    }

    @Test
    public void testRequiresWorkspaceForPollingMultiBranch() {
        ArrayList<BranchSpec> branches = new ArrayList<BranchSpec>();
        branches.add(new BranchSpec("master"));
        branches.add(new BranchSpec("origin/master"));
        GitSCM bigGitSCM = new GitSCM(GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", null), branches, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        Assert.assertTrue((boolean)bigGitSCM.requiresWorkspaceForPolling());
    }

    @Test
    public void testRequiresWorkspaceForPollingEmptyBranchName() {
        EnvVars env = new EnvVars();
        env.put("A", "");
        GitSCM bigGitSCM = new GitSCM(GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", null), Collections.singletonList(new BranchSpec("${A}")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        Assert.assertFalse((boolean)bigGitSCM.requiresWorkspaceForPolling(env));
    }

    @Test
    public void testCreateChangeLogParser() {
        Assert.assertThat((Object)this.gitSCM.createChangeLogParser(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(GitChangeLogParser.class)));
    }

    @Test
    public void testIsDoGenerateSubmoduleConfigurations() {
        Assert.assertFalse((boolean)this.gitSCM.isDoGenerateSubmoduleConfigurations());
    }

    @Test
    public void testIsDoGenerateSubmoduleConfigurationsTrue() {
        GitSCM bigGitSCM = new GitSCM(GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", null), Collections.singletonList(new BranchSpec("master")), Boolean.valueOf(true), Collections.emptyList(), null, null, Collections.emptyList());
        Assert.assertTrue((boolean)bigGitSCM.isDoGenerateSubmoduleConfigurations());
    }

    @Test
    public void testGetBranches() {
        ArrayList<BranchSpec> expectedBranchList = new ArrayList<BranchSpec>();
        expectedBranchList.add(new BranchSpec("**"));
        this.assertBranchSpecListEquals(this.gitSCM.getBranches(), expectedBranchList);
    }

    private void assertBranchSpecListEquals(List<BranchSpec> branchList, List<BranchSpec> expectedBranchList) {
        int expectedIndex = 0;
        for (BranchSpec branchSpec : branchList) {
            Assert.assertThat((Object)branchSpec.getName(), (Matcher)Matchers.is((Object)expectedBranchList.get(expectedIndex++).getName()));
        }
        Assert.assertThat((Object)branchList.size(), (Matcher)Matchers.is((Object)expectedBranchList.size()));
    }

    @Test
    public void testGetKey() {
        Assert.assertThat((Object)this.gitSCM.getKey(), (Matcher)Matchers.is((Object)"git ."));
    }

    @Test
    @Deprecated
    public void testGetMergeOptions() throws Exception {
        PreBuildMergeOptions expectedMergeOptions = new PreBuildMergeOptions();
        PreBuildMergeOptions mergeOptions = this.gitSCM.getMergeOptions();
        Assert.assertThat((Object)mergeOptions.getRemoteBranchName(), (Matcher)Matchers.is((Object)expectedMergeOptions.getRemoteBranchName()));
        Assert.assertThat((Object)mergeOptions.getMergeTarget(), (Matcher)Matchers.is((Object)expectedMergeOptions.getMergeTarget()));
    }
}

